/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pekko.cluster.singleton;

import com.typesafe.config.Config;
import org.apache.pekko.actor.ActorSystem;
import org.apache.pekko.actor.NoSerializationVerificationNeeded;
import org.apache.pekko.cluster.singleton.ClusterSingletonProxySettings$;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Some$;
import scala.concurrent.duration.FiniteDuration;

public final class ClusterSingletonProxySettings
implements NoSerializationVerificationNeeded {
    private final String singletonName;
    private final Option role;
    private final Option dataCenter;
    private final FiniteDuration singletonIdentificationInterval;
    private final int bufferSize;

    public static ClusterSingletonProxySettings apply(ActorSystem actorSystem) {
        return ClusterSingletonProxySettings$.MODULE$.apply(actorSystem);
    }

    public static ClusterSingletonProxySettings apply(Config config) {
        return ClusterSingletonProxySettings$.MODULE$.apply(config);
    }

    public static ClusterSingletonProxySettings create(ActorSystem actorSystem) {
        return ClusterSingletonProxySettings$.MODULE$.create(actorSystem);
    }

    public static ClusterSingletonProxySettings create(Config config) {
        return ClusterSingletonProxySettings$.MODULE$.create(config);
    }

    public static Option<String> roleOption(String string) {
        return ClusterSingletonProxySettings$.MODULE$.roleOption(string);
    }

    public ClusterSingletonProxySettings(String singletonName, Option<String> role, Option<String> dataCenter, FiniteDuration singletonIdentificationInterval, int bufferSize) {
        this.singletonName = singletonName;
        this.role = role;
        this.dataCenter = dataCenter;
        this.singletonIdentificationInterval = singletonIdentificationInterval;
        this.bufferSize = bufferSize;
        Predef$.MODULE$.require(bufferSize >= 0 && bufferSize <= 10000, ClusterSingletonProxySettings::$init$$$anonfun$1);
    }

    public String singletonName() {
        return this.singletonName;
    }

    public Option<String> role() {
        return this.role;
    }

    public Option<String> dataCenter() {
        return this.dataCenter;
    }

    public FiniteDuration singletonIdentificationInterval() {
        return this.singletonIdentificationInterval;
    }

    public int bufferSize() {
        return this.bufferSize;
    }

    public ClusterSingletonProxySettings(String singletonName, Option<String> role, FiniteDuration singletonIdentificationInterval, int bufferSize) {
        this(singletonName, role, (Option<String>)None$.MODULE$, singletonIdentificationInterval, bufferSize);
    }

    public ClusterSingletonProxySettings withSingletonName(String name) {
        return this.copy(name, this.copy$default$2(), this.copy$default$3(), this.copy$default$4(), this.copy$default$5());
    }

    public ClusterSingletonProxySettings withRole(String role) {
        Option<String> option = ClusterSingletonProxySettings$.MODULE$.roleOption(role);
        String string = this.copy$default$1();
        Option<String> option2 = this.copy$default$3();
        FiniteDuration finiteDuration = this.copy$default$4();
        int n = this.copy$default$5();
        return this.copy(string, option, option2, finiteDuration, n);
    }

    public ClusterSingletonProxySettings withRole(Option<String> role) {
        return this.copy(this.copy$default$1(), role, this.copy$default$3(), this.copy$default$4(), this.copy$default$5());
    }

    public ClusterSingletonProxySettings withDataCenter(String dataCenter) {
        Some some = Some$.MODULE$.apply((Object)dataCenter);
        String string = this.copy$default$1();
        Option<String> option = this.copy$default$2();
        FiniteDuration finiteDuration = this.copy$default$4();
        int n = this.copy$default$5();
        return this.copy(string, option, (Option<String>)some, finiteDuration, n);
    }

    public ClusterSingletonProxySettings withDataCenter(Option<String> dataCenter) {
        return this.copy(this.copy$default$1(), this.copy$default$2(), dataCenter, this.copy$default$4(), this.copy$default$5());
    }

    public ClusterSingletonProxySettings withSingletonIdentificationInterval(FiniteDuration singletonIdentificationInterval) {
        return this.copy(this.copy$default$1(), this.copy$default$2(), this.copy$default$3(), singletonIdentificationInterval, this.copy$default$5());
    }

    public ClusterSingletonProxySettings withBufferSize(int bufferSize) {
        return this.copy(this.copy$default$1(), this.copy$default$2(), this.copy$default$3(), this.copy$default$4(), bufferSize);
    }

    private ClusterSingletonProxySettings copy(String singletonName, Option<String> role, Option<String> dataCenter, FiniteDuration singletonIdentificationInterval, int bufferSize) {
        return new ClusterSingletonProxySettings(singletonName, role, dataCenter, singletonIdentificationInterval, bufferSize);
    }

    private String copy$default$1() {
        return this.singletonName();
    }

    private Option<String> copy$default$2() {
        return this.role();
    }

    private Option<String> copy$default$3() {
        return this.dataCenter();
    }

    private FiniteDuration copy$default$4() {
        return this.singletonIdentificationInterval();
    }

    private int copy$default$5() {
        return this.bufferSize();
    }

    private static final Object $init$$$anonfun$1() {
        return "bufferSize must be >= 0 and <= 10000";
    }
}

