/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pekko.cluster.singleton;

import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import org.apache.pekko.actor.Actor;
import org.apache.pekko.actor.ActorContext;
import org.apache.pekko.actor.ActorIdentity;
import org.apache.pekko.actor.ActorIdentity$;
import org.apache.pekko.actor.ActorLogging;
import org.apache.pekko.actor.ActorPath;
import org.apache.pekko.actor.ActorRef;
import org.apache.pekko.actor.ActorSelection$;
import org.apache.pekko.actor.Cancellable;
import org.apache.pekko.actor.Identify$;
import org.apache.pekko.actor.Props;
import org.apache.pekko.actor.RootActorPath$;
import org.apache.pekko.actor.Terminated;
import org.apache.pekko.actor.Terminated$;
import org.apache.pekko.cluster.Cluster;
import org.apache.pekko.cluster.Cluster$;
import org.apache.pekko.cluster.ClusterEvent;
import org.apache.pekko.cluster.ClusterSettings$;
import org.apache.pekko.cluster.Member;
import org.apache.pekko.cluster.Member$;
import org.apache.pekko.cluster.MemberStatus;
import org.apache.pekko.cluster.UniqueAddress;
import org.apache.pekko.cluster.singleton.ClusterSingletonProxy$;
import org.apache.pekko.cluster.singleton.ClusterSingletonProxy$TryToIdentifySingleton$;
import org.apache.pekko.cluster.singleton.ClusterSingletonProxySettings;
import org.apache.pekko.event.Logging$;
import org.apache.pekko.event.LoggingAdapter;
import org.apache.pekko.util.MessageBuffer;
import org.apache.pekko.util.MessageBuffer$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Predef$;
import scala.Some;
import scala.Some$;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.Set;
import scala.collection.SetOps;
import scala.collection.immutable.Seq;
import scala.collection.immutable.SortedSet;
import scala.collection.immutable.SortedSet$;
import scala.concurrent.ExecutionContext;
import scala.concurrent.duration.Duration$;
import scala.math.Ordering;
import scala.runtime.BoxedUnit;
import scala.runtime.LambdaDeserialize;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.runtime.function.JProcedure1;
import scala.runtime.function.JProcedure2;
import scala.runtime.java8.JFunction0;

public final class ClusterSingletonProxy
implements Actor,
ActorLogging {
    private ActorContext context;
    private ActorRef self;
    private LoggingAdapter org$apache$pekko$actor$ActorLogging$$_log;
    private final ClusterSingletonProxySettings settings;
    private final String[] singletonPath;
    private int identifyCounter;
    private String identifyId;
    private Option identifyTimer;
    private final Cluster cluster;
    private Option singleton;
    private final Ordering ageOrdering;
    private SortedSet membersByAge;
    private MessageBuffer buffer;
    private final String targetDcRole;

    public static Props props(String string, ClusterSingletonProxySettings clusterSingletonProxySettings) {
        return ClusterSingletonProxy$.MODULE$.props(string, clusterSingletonProxySettings);
    }

    public ClusterSingletonProxy(String singletonManagerPath, ClusterSingletonProxySettings settings) {
        String string;
        this.settings = settings;
        Actor.$init$((Actor)this);
        ActorLogging.$init$((ActorLogging)this);
        this.singletonPath = new StringBuilder(1).append(singletonManagerPath).append("/").append(settings.singletonName()).toString().split("/");
        this.identifyCounter = 0;
        this.identifyId = this.createIdentifyId(this.identifyCounter());
        this.identifyTimer = None$.MODULE$;
        this.cluster = (Cluster)Cluster$.MODULE$.apply(this.context().system());
        this.singleton = None$.MODULE$;
        this.ageOrdering = Member$.MODULE$.ageOrdering();
        this.membersByAge = (SortedSet)SortedSet$.MODULE$.empty(this.ageOrdering());
        this.buffer = MessageBuffer$.MODULE$.empty();
        Option<String> option = settings.dataCenter();
        if (option instanceof Some) {
            String t = (String)((Some)option).value();
            string = new StringBuilder(0).append(ClusterSettings$.MODULE$.DcRolePrefix()).append(t).toString();
        } else if (None$.MODULE$.equals(option)) {
            string = new StringBuilder(0).append(ClusterSettings$.MODULE$.DcRolePrefix()).append(this.cluster().settings().SelfDataCenter()).toString();
        } else {
            throw new MatchError(option);
        }
        this.targetDcRole = string;
        Statics.releaseFence();
    }

    public ActorContext context() {
        return this.context;
    }

    public final ActorRef self() {
        return this.self;
    }

    public void org$apache$pekko$actor$Actor$_setter_$context_$eq(ActorContext x$0) {
        this.context = x$0;
    }

    public void org$apache$pekko$actor$Actor$_setter_$self_$eq(ActorRef x$0) {
        this.self = x$0;
    }

    public LoggingAdapter org$apache$pekko$actor$ActorLogging$$_log() {
        return this.org$apache$pekko$actor$ActorLogging$$_log;
    }

    public void org$apache$pekko$actor$ActorLogging$$_log_$eq(LoggingAdapter x$1) {
        this.org$apache$pekko$actor$ActorLogging$$_log = x$1;
    }

    public String[] singletonPath() {
        return this.singletonPath;
    }

    public int identifyCounter() {
        return this.identifyCounter;
    }

    public void identifyCounter_$eq(int x$1) {
        this.identifyCounter = x$1;
    }

    public String identifyId() {
        return this.identifyId;
    }

    public void identifyId_$eq(String x$1) {
        this.identifyId = x$1;
    }

    public String createIdentifyId(int i) {
        return new StringBuilder(19).append("identify-singleton-").append(Predef$.MODULE$.wrapRefArray((Object[])this.singletonPath()).mkString("/")).append(i).toString();
    }

    public Option<Cancellable> identifyTimer() {
        return this.identifyTimer;
    }

    public void identifyTimer_$eq(Option<Cancellable> x$1) {
        this.identifyTimer = x$1;
    }

    public Cluster cluster() {
        return this.cluster;
    }

    public Option<ActorRef> singleton() {
        return this.singleton;
    }

    public void singleton_$eq(Option<ActorRef> x$1) {
        this.singleton = x$1;
    }

    public Ordering<Member> ageOrdering() {
        return this.ageOrdering;
    }

    public SortedSet<Member> membersByAge() {
        return this.membersByAge;
    }

    public void membersByAge_$eq(SortedSet<Member> x$1) {
        this.membersByAge = x$1;
    }

    public MessageBuffer buffer() {
        return this.buffer;
    }

    public void buffer_$eq(MessageBuffer x$1) {
        this.buffer = x$1;
    }

    public void preStart() {
        this.cancelTimer();
        this.cluster().subscribe(this.self(), (Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Class[]{ClusterEvent.MemberEvent.class}));
    }

    public void postStop() {
        this.cancelTimer();
        this.cluster().unsubscribe(this.self());
    }

    public void cancelTimer() {
        this.identifyTimer().foreach((Function1 & Serializable)_$1 -> _$1.cancel());
        this.identifyTimer_$eq((Option<Cancellable>)None$.MODULE$);
    }

    public boolean matchingRole(Member member) {
        return member.hasRole(this.targetDcRole) && this.settings.role().forall((Function1 & Serializable)role -> member.hasRole(role));
    }

    public void handleInitial(ClusterEvent.CurrentClusterState state) {
        this.trackChange((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> this.membersByAge_$eq((SortedSet<Member>)((SortedSet)((SetOps)SortedSet$.MODULE$.empty(this.ageOrdering())).union((Set)state.members().collect((PartialFunction)new Serializable(this){
            private final /* synthetic */ ClusterSingletonProxy $outer;
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }

            public final boolean isDefinedAt(Member x) {
                Member member;
                Member m = member = x;
                MemberStatus memberStatus = m.status();
                MemberStatus.Up$ up$ = MemberStatus.Up$.MODULE$;
                return !(memberStatus != null ? !memberStatus.equals(up$) : up$ != null) && this.$outer.matchingRole(m);
            }

            public final Object applyOrElse(Member x, Function1 function1) {
                Member member;
                Member m = member = x;
                MemberStatus memberStatus = m.status();
                MemberStatus.Up$ up$ = MemberStatus.Up$.MODULE$;
                if (!(memberStatus != null ? !memberStatus.equals(up$) : up$ != null) && this.$outer.matchingRole(m)) {
                    return m;
                }
                return function1.apply((Object)x);
            }
        }, Member$.MODULE$.ordering())))));
    }

    public void identifySingleton() {
        this.log().debug("Creating singleton identification timer...");
        this.identifyCounter_$eq(this.identifyCounter() + 1);
        this.identifyId_$eq(this.createIdentifyId(this.identifyCounter()));
        this.singleton_$eq((Option<ActorRef>)None$.MODULE$);
        this.cancelTimer();
        this.identifyTimer_$eq((Option<Cancellable>)Some$.MODULE$.apply((Object)this.context().system().scheduler().scheduleWithFixedDelay(Duration$.MODULE$.Zero(), this.settings.singletonIdentificationInterval(), this.self(), (Object)ClusterSingletonProxy$TryToIdentifySingleton$.MODULE$, (ExecutionContext)this.context().dispatcher(), this.self())));
    }

    public void trackChange(Function0<BoxedUnit> block) {
        Option before = this.membersByAge().headOption();
        block.apply$mcV$sp();
        Option after = this.membersByAge().headOption();
        Option option = before;
        Option option2 = after;
        if (option == null ? option2 != null : !option.equals(option2)) {
            this.identifySingleton();
            return;
        }
    }

    public void add(Member m) {
        if (this.matchingRole(m)) {
            this.trackChange((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> {
                this.membersByAge_$eq((SortedSet<Member>)((SortedSet)this.membersByAge().filterNot((Function1 & Serializable)_$2 -> {
                    UniqueAddress uniqueAddress = _$2.uniqueAddress();
                    UniqueAddress uniqueAddress2 = m.uniqueAddress();
                    return !(uniqueAddress != null ? !uniqueAddress.equals(uniqueAddress2) : uniqueAddress2 != null);
                })));
                this.membersByAge_$eq((SortedSet<Member>)((SortedSet)this.membersByAge().$plus((Object)m)));
            });
            return;
        }
    }

    public void remove(Member m) {
        if (this.matchingRole(m)) {
            this.trackChange((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> this.membersByAge_$eq((SortedSet<Member>)((SortedSet)this.membersByAge().filterNot((Function1 & Serializable)_$3 -> {
                UniqueAddress uniqueAddress = _$3.uniqueAddress();
                UniqueAddress uniqueAddress2 = m.uniqueAddress();
                return !(uniqueAddress != null ? !uniqueAddress.equals(uniqueAddress2) : uniqueAddress2 != null);
            }))));
            return;
        }
    }

    public PartialFunction<Object, BoxedUnit> receive() {
        return new Serializable(this){
            private final /* synthetic */ ClusterSingletonProxy $outer;
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }

            public final boolean isDefinedAt(Object x) {
                Object object = x;
                if (object instanceof ClusterEvent.CurrentClusterState) {
                    ClusterEvent.CurrentClusterState state = (ClusterEvent.CurrentClusterState)object;
                    return true;
                }
                if (object instanceof ClusterEvent.MemberUp) {
                    Member member;
                    ClusterEvent.MemberUp memberUp = ClusterEvent.MemberUp$.MODULE$.unapply((ClusterEvent.MemberUp)object);
                    Member m = member = memberUp._1();
                    return true;
                }
                if (object instanceof ClusterEvent.MemberExited) {
                    Member member;
                    ClusterEvent.MemberExited memberExited = ClusterEvent.MemberExited$.MODULE$.unapply((ClusterEvent.MemberExited)object);
                    Member m = member = memberExited._1();
                    return true;
                }
                if (object instanceof ClusterEvent.MemberRemoved) {
                    ClusterEvent.MemberRemoved memberRemoved = ClusterEvent.MemberRemoved$.MODULE$.unapply((ClusterEvent.MemberRemoved)object);
                    Member member = memberRemoved._1();
                    MemberStatus memberStatus = memberRemoved._2();
                    Member m = member;
                    return true;
                }
                if (object instanceof ClusterEvent.MemberEvent) {
                    return true;
                }
                if (object instanceof ActorIdentity) {
                    ActorIdentity actorIdentity = ActorIdentity$.MODULE$.unapply((ActorIdentity)object);
                    Object object2 = actorIdentity._1();
                    Option option = actorIdentity._2();
                    if (option instanceof Some) {
                        ActorRef s = (ActorRef)((Some)option).value();
                        return true;
                    }
                    return true;
                }
                if (ClusterSingletonProxy$TryToIdentifySingleton$.MODULE$.equals(object)) {
                    return true;
                }
                if (object instanceof Terminated) {
                    ActorRef actorRef;
                    Terminated terminated = Terminated$.MODULE$.unapply((Terminated)object);
                    ActorRef ref = actorRef = terminated._1();
                    return true;
                }
                if (object instanceof Object) {
                    Object msg = object;
                    return true;
                }
                return false;
            }

            public final Object applyOrElse(Object x, Function1 function1) {
                Object object = x;
                if (object instanceof ClusterEvent.CurrentClusterState) {
                    ClusterEvent.CurrentClusterState state = (ClusterEvent.CurrentClusterState)object;
                    this.$outer.handleInitial(state);
                    return BoxedUnit.UNIT;
                }
                if (object instanceof ClusterEvent.MemberUp) {
                    Member member;
                    ClusterEvent.MemberUp memberUp = ClusterEvent.MemberUp$.MODULE$.unapply((ClusterEvent.MemberUp)object);
                    Member m = member = memberUp._1();
                    this.$outer.add(m);
                    return BoxedUnit.UNIT;
                }
                if (object instanceof ClusterEvent.MemberExited) {
                    Member member;
                    ClusterEvent.MemberExited memberExited = ClusterEvent.MemberExited$.MODULE$.unapply((ClusterEvent.MemberExited)object);
                    Member m = member = memberExited._1();
                    this.$outer.remove(m);
                    return BoxedUnit.UNIT;
                }
                if (object instanceof ClusterEvent.MemberRemoved) {
                    ClusterEvent.MemberRemoved memberRemoved = ClusterEvent.MemberRemoved$.MODULE$.unapply((ClusterEvent.MemberRemoved)object);
                    Member member = memberRemoved._1();
                    MemberStatus memberStatus = memberRemoved._2();
                    Member m = member;
                    UniqueAddress uniqueAddress = m.uniqueAddress();
                    UniqueAddress uniqueAddress2 = this.$outer.cluster().selfUniqueAddress();
                    if (!(uniqueAddress != null ? !uniqueAddress.equals(uniqueAddress2) : uniqueAddress2 != null)) {
                        this.$outer.context().stop(this.$outer.self());
                        return BoxedUnit.UNIT;
                    }
                    this.$outer.remove(m);
                    return BoxedUnit.UNIT;
                }
                if (object instanceof ClusterEvent.MemberEvent) {
                    return BoxedUnit.UNIT;
                }
                if (object instanceof ActorIdentity) {
                    ActorIdentity actorIdentity = ActorIdentity$.MODULE$.unapply((ActorIdentity)object);
                    Object object2 = actorIdentity._1();
                    Option option = actorIdentity._2();
                    if (option instanceof Some) {
                        ActorRef s = (ActorRef)((Some)option).value();
                        this.$outer.log().info("Singleton identified at [{}]", (Object)s.path());
                        this.$outer.singleton_$eq((Option<ActorRef>)Some$.MODULE$.apply((Object)s));
                        this.$outer.context().watch(s);
                        this.$outer.cancelTimer();
                        this.$outer.sendBuffered();
                        return BoxedUnit.UNIT;
                    }
                    return BoxedUnit.UNIT;
                }
                if (ClusterSingletonProxy$TryToIdentifySingleton$.MODULE$.equals(object)) {
                    Option<Cancellable> option = this.$outer.identifyTimer();
                    if (option instanceof Some) {
                        this.$outer.membersByAge().headOption().foreach((Function1)(JProcedure1 & Serializable)oldest -> {
                            ActorPath singletonAddress = RootActorPath$.MODULE$.apply(oldest.address(), RootActorPath$.MODULE$.$lessinit$greater$default$2()).$div((Iterable)Predef$.MODULE$.wrapRefArray((Object[])this.$outer.singletonPath()));
                            this.$outer.log().debug("Trying to identify singleton at [{}]", (Object)singletonAddress);
                            ActorSelection$.MODULE$.toScala(this.$outer.context().actorSelection(singletonAddress)).$bang((Object)Identify$.MODULE$.apply((Object)this.$outer.identifyId()), this.$outer.self());
                        });
                    }
                    return BoxedUnit.UNIT;
                }
                if (object instanceof Terminated) {
                    ActorRef actorRef;
                    Terminated terminated = Terminated$.MODULE$.unapply((Terminated)object);
                    ActorRef ref = actorRef = terminated._1();
                    if (this.$outer.singleton().contains((Object)ref)) {
                        this.$outer.singleton_$eq((Option<ActorRef>)None$.MODULE$);
                        return BoxedUnit.UNIT;
                    }
                    return BoxedUnit.UNIT;
                }
                if (object instanceof Object) {
                    Object msg = object;
                    Option<ActorRef> option = this.$outer.singleton();
                    if (option instanceof Some) {
                        ActorRef s = (ActorRef)((Some)option).value();
                        if (this.$outer.log().isDebugEnabled()) {
                            this.$outer.log().debug("Forwarding message of type [{}] to current singleton instance at [{}]", (Object)Logging$.MODULE$.simpleName(msg.getClass()), (Object)s.path());
                        }
                        s.forward(msg, this.$outer.context());
                    } else if (None$.MODULE$.equals(option)) {
                        this.$outer.buffer(msg);
                    } else {
                        throw new MatchError(option);
                    }
                    return BoxedUnit.UNIT;
                }
                return function1.apply(x);
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{applyOrElse$$anonfun$1(org.apache.pekko.cluster.Member )}, serializedLambda);
            }
        };
    }

    public void buffer(Object msg) {
        if (this.settings.bufferSize() == 0) {
            this.log().debug("Singleton not available and buffering is disabled, dropping message [{}]", (Object)msg.getClass().getName());
            return;
        }
        if (this.buffer().size() == this.settings.bufferSize()) {
            Tuple2 tuple2 = this.buffer().head();
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            Object m = tuple2._1();
            Object m2 = m;
            this.buffer().dropHead();
            this.log().debug("Singleton not available, buffer is full, dropping first message [{}]", (Object)m2.getClass().getName());
            this.buffer().append(msg, this.sender());
            return;
        }
        this.log().debug("Singleton not available, buffering message type [{}]", (Object)msg.getClass().getName());
        this.buffer().append(msg, this.sender());
    }

    public void sendBuffered() {
        this.log().debug("Sending buffered messages to current singleton instance");
        ActorRef target = (ActorRef)this.singleton().get();
        this.buffer().foreach((Function2)(JProcedure2 & Serializable)(msg, snd) -> target.tell(msg, snd));
        this.buffer_$eq(MessageBuffer$.MODULE$.empty());
    }
}

