/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pekko.cluster.singleton;

import com.typesafe.config.Config;
import org.apache.pekko.actor.ActorSystem;
import org.apache.pekko.actor.NoSerializationVerificationNeeded;
import org.apache.pekko.cluster.singleton.ClusterSingletonManagerSettings$;
import org.apache.pekko.coordination.lease.LeaseUsageSettings;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.Some$;
import scala.concurrent.duration.FiniteDuration;

public final class ClusterSingletonManagerSettings
implements NoSerializationVerificationNeeded {
    private final String singletonName;
    private final Option role;
    private final FiniteDuration removalMargin;
    private final FiniteDuration handOverRetryInterval;
    private final Option leaseSettings;

    public static ClusterSingletonManagerSettings apply(ActorSystem actorSystem) {
        return ClusterSingletonManagerSettings$.MODULE$.apply(actorSystem);
    }

    public static ClusterSingletonManagerSettings apply(Config config) {
        return ClusterSingletonManagerSettings$.MODULE$.apply(config);
    }

    public static ClusterSingletonManagerSettings create(ActorSystem actorSystem) {
        return ClusterSingletonManagerSettings$.MODULE$.create(actorSystem);
    }

    public static ClusterSingletonManagerSettings create(Config config) {
        return ClusterSingletonManagerSettings$.MODULE$.create(config);
    }

    public static Option<String> roleOption(String string) {
        return ClusterSingletonManagerSettings$.MODULE$.roleOption(string);
    }

    public ClusterSingletonManagerSettings(String singletonName, Option<String> role, FiniteDuration removalMargin, FiniteDuration handOverRetryInterval, Option<LeaseUsageSettings> leaseSettings) {
        this.singletonName = singletonName;
        this.role = role;
        this.removalMargin = removalMargin;
        this.handOverRetryInterval = handOverRetryInterval;
        this.leaseSettings = leaseSettings;
    }

    public String singletonName() {
        return this.singletonName;
    }

    public Option<String> role() {
        return this.role;
    }

    public FiniteDuration removalMargin() {
        return this.removalMargin;
    }

    public FiniteDuration handOverRetryInterval() {
        return this.handOverRetryInterval;
    }

    public Option<LeaseUsageSettings> leaseSettings() {
        return this.leaseSettings;
    }

    public ClusterSingletonManagerSettings(String singletonName, Option<String> role, FiniteDuration removalMargin, FiniteDuration handOverRetryInterval) {
        this(singletonName, role, removalMargin, handOverRetryInterval, (Option<LeaseUsageSettings>)None$.MODULE$);
    }

    public ClusterSingletonManagerSettings withSingletonName(String name) {
        return this.copy(name, this.copy$default$2(), this.copy$default$3(), this.copy$default$4(), this.copy$default$5());
    }

    public ClusterSingletonManagerSettings withRole(String role) {
        Option<String> option = ClusterSingletonManagerSettings$.MODULE$.roleOption(role);
        String string = this.copy$default$1();
        FiniteDuration finiteDuration = this.copy$default$3();
        FiniteDuration finiteDuration2 = this.copy$default$4();
        Option<LeaseUsageSettings> option2 = this.copy$default$5();
        return this.copy(string, option, finiteDuration, finiteDuration2, option2);
    }

    public ClusterSingletonManagerSettings withRole(Option<String> role) {
        return this.copy(this.copy$default$1(), role, this.copy$default$3(), this.copy$default$4(), this.copy$default$5());
    }

    public ClusterSingletonManagerSettings withRemovalMargin(FiniteDuration removalMargin) {
        return this.copy(this.copy$default$1(), this.copy$default$2(), removalMargin, this.copy$default$4(), this.copy$default$5());
    }

    public ClusterSingletonManagerSettings withHandOverRetryInterval(FiniteDuration retryInterval) {
        return this.copy(this.copy$default$1(), this.copy$default$2(), this.copy$default$3(), retryInterval, this.copy$default$5());
    }

    public ClusterSingletonManagerSettings withLeaseSettings(LeaseUsageSettings leaseSettings) {
        Some some = Some$.MODULE$.apply((Object)leaseSettings);
        String string = this.copy$default$1();
        Option<String> option = this.copy$default$2();
        FiniteDuration finiteDuration = this.copy$default$3();
        FiniteDuration finiteDuration2 = this.copy$default$4();
        return this.copy(string, option, finiteDuration, finiteDuration2, (Option<LeaseUsageSettings>)some);
    }

    private ClusterSingletonManagerSettings copy(String singletonName, Option<String> role, FiniteDuration removalMargin, FiniteDuration handOverRetryInterval, Option<LeaseUsageSettings> leaseSettings) {
        return new ClusterSingletonManagerSettings(singletonName, role, removalMargin, handOverRetryInterval, leaseSettings);
    }

    private String copy$default$1() {
        return this.singletonName();
    }

    private Option<String> copy$default$2() {
        return this.role();
    }

    private FiniteDuration copy$default$3() {
        return this.removalMargin();
    }

    private FiniteDuration copy$default$4() {
        return this.handOverRetryInterval();
    }

    private Option<LeaseUsageSettings> copy$default$5() {
        return this.leaseSettings();
    }
}

