/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pekko.cluster.pubsub;

import com.typesafe.config.Config;
import org.apache.pekko.actor.ActorSystem;
import org.apache.pekko.actor.NoSerializationVerificationNeeded;
import org.apache.pekko.cluster.pubsub.DistributedPubSubSettings$;
import org.apache.pekko.routing.ConsistentHashingRoutingLogic;
import org.apache.pekko.routing.RoutingLogic;
import scala.Option;
import scala.Predef$;
import scala.concurrent.duration.FiniteDuration;

public final class DistributedPubSubSettings
implements NoSerializationVerificationNeeded {
    private final Option role;
    private final RoutingLogic routingLogic;
    private final FiniteDuration gossipInterval;
    private final FiniteDuration removedTimeToLive;
    private final int maxDeltaElements;
    private final boolean sendToDeadLettersWhenNoSubscribers;

    public static DistributedPubSubSettings apply(ActorSystem actorSystem) {
        return DistributedPubSubSettings$.MODULE$.apply(actorSystem);
    }

    public static DistributedPubSubSettings apply(Config config) {
        return DistributedPubSubSettings$.MODULE$.apply(config);
    }

    public static DistributedPubSubSettings create(ActorSystem actorSystem) {
        return DistributedPubSubSettings$.MODULE$.create(actorSystem);
    }

    public static DistributedPubSubSettings create(Config config) {
        return DistributedPubSubSettings$.MODULE$.create(config);
    }

    public static Option<String> roleOption(String string) {
        return DistributedPubSubSettings$.MODULE$.roleOption(string);
    }

    public DistributedPubSubSettings(Option<String> role, RoutingLogic routingLogic, FiniteDuration gossipInterval, FiniteDuration removedTimeToLive, int maxDeltaElements, boolean sendToDeadLettersWhenNoSubscribers) {
        this.role = role;
        this.routingLogic = routingLogic;
        this.gossipInterval = gossipInterval;
        this.removedTimeToLive = removedTimeToLive;
        this.maxDeltaElements = maxDeltaElements;
        this.sendToDeadLettersWhenNoSubscribers = sendToDeadLettersWhenNoSubscribers;
        Predef$.MODULE$.require(!(routingLogic instanceof ConsistentHashingRoutingLogic), DistributedPubSubSettings::$init$$$anonfun$1);
    }

    public Option<String> role() {
        return this.role;
    }

    public RoutingLogic routingLogic() {
        return this.routingLogic;
    }

    public FiniteDuration gossipInterval() {
        return this.gossipInterval;
    }

    public FiniteDuration removedTimeToLive() {
        return this.removedTimeToLive;
    }

    public int maxDeltaElements() {
        return this.maxDeltaElements;
    }

    public boolean sendToDeadLettersWhenNoSubscribers() {
        return this.sendToDeadLettersWhenNoSubscribers;
    }

    public DistributedPubSubSettings(Option<String> role, RoutingLogic routingLogic, FiniteDuration gossipInterval, FiniteDuration removedTimeToLive, int maxDeltaElements) {
        this(role, routingLogic, gossipInterval, removedTimeToLive, maxDeltaElements, true);
    }

    public DistributedPubSubSettings withRole(String role) {
        return this.copy(DistributedPubSubSettings$.MODULE$.roleOption(role), this.copy$default$2(), this.copy$default$3(), this.copy$default$4(), this.copy$default$5(), this.copy$default$6());
    }

    public DistributedPubSubSettings withRole(Option<String> role) {
        return this.copy(role, this.copy$default$2(), this.copy$default$3(), this.copy$default$4(), this.copy$default$5(), this.copy$default$6());
    }

    public DistributedPubSubSettings withRoutingLogic(RoutingLogic routingLogic) {
        return this.copy(this.copy$default$1(), routingLogic, this.copy$default$3(), this.copy$default$4(), this.copy$default$5(), this.copy$default$6());
    }

    public DistributedPubSubSettings withGossipInterval(FiniteDuration gossipInterval) {
        return this.copy(this.copy$default$1(), this.copy$default$2(), gossipInterval, this.copy$default$4(), this.copy$default$5(), this.copy$default$6());
    }

    public DistributedPubSubSettings withRemovedTimeToLive(FiniteDuration removedTimeToLive) {
        return this.copy(this.copy$default$1(), this.copy$default$2(), this.copy$default$3(), removedTimeToLive, this.copy$default$5(), this.copy$default$6());
    }

    public DistributedPubSubSettings withMaxDeltaElements(int maxDeltaElements) {
        return this.copy(this.copy$default$1(), this.copy$default$2(), this.copy$default$3(), this.copy$default$4(), maxDeltaElements, this.copy$default$6());
    }

    public DistributedPubSubSettings withSendToDeadLettersWhenNoSubscribers(boolean sendToDeadLetterWhenNoSubscribers) {
        return this.copy(this.copy$default$1(), this.copy$default$2(), this.copy$default$3(), this.copy$default$4(), this.copy$default$5(), sendToDeadLetterWhenNoSubscribers);
    }

    private DistributedPubSubSettings copy(Option<String> role, RoutingLogic routingLogic, FiniteDuration gossipInterval, FiniteDuration removedTimeToLive, int maxDeltaElements, boolean sendToDeadLettersWhenNoSubscribers) {
        return new DistributedPubSubSettings(role, routingLogic, gossipInterval, removedTimeToLive, maxDeltaElements, sendToDeadLettersWhenNoSubscribers);
    }

    private Option<String> copy$default$1() {
        return this.role();
    }

    private RoutingLogic copy$default$2() {
        return this.routingLogic();
    }

    private FiniteDuration copy$default$3() {
        return this.gossipInterval();
    }

    private FiniteDuration copy$default$4() {
        return this.removedTimeToLive();
    }

    private int copy$default$5() {
        return this.maxDeltaElements();
    }

    private boolean copy$default$6() {
        return this.sendToDeadLettersWhenNoSubscribers();
    }

    private static final Object $init$$$anonfun$1() {
        return "'ConsistentHashingRoutingLogic' can't be used by the pub-sub mediator";
    }
}

