/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pekko.cluster.pubsub;

import java.io.Serializable;
import org.apache.pekko.actor.ActorRef;
import org.apache.pekko.actor.ActorSystem;
import org.apache.pekko.actor.ClassicActorSystemProvider;
import org.apache.pekko.actor.ExtendedActorSystem;
import org.apache.pekko.actor.Extension;
import org.apache.pekko.actor.ExtensionId;
import org.apache.pekko.cluster.Cluster;
import org.apache.pekko.cluster.Cluster$;
import org.apache.pekko.cluster.pubsub.DistributedPubSub$;
import org.apache.pekko.cluster.pubsub.DistributedPubSubMediator$;
import org.apache.pekko.cluster.pubsub.DistributedPubSubSettings;
import org.apache.pekko.cluster.pubsub.DistributedPubSubSettings$;
import scala.Function1;
import scala.collection.immutable.Set;

public class DistributedPubSub
implements Extension {
    private final ExtendedActorSystem system;
    private final DistributedPubSubSettings settings;
    private final ActorRef mediator;

    public static Extension apply(ActorSystem actorSystem) {
        return DistributedPubSub$.MODULE$.apply(actorSystem);
    }

    public static Extension apply(ClassicActorSystemProvider classicActorSystemProvider) {
        return DistributedPubSub$.MODULE$.apply(classicActorSystemProvider);
    }

    public static DistributedPubSub createExtension(ExtendedActorSystem extendedActorSystem) {
        return DistributedPubSub$.MODULE$.createExtension(extendedActorSystem);
    }

    public static DistributedPubSub get(ActorSystem actorSystem) {
        return DistributedPubSub$.MODULE$.get(actorSystem);
    }

    public static /* synthetic */ Extension get(ActorSystem actorSystem) {
        return DistributedPubSub$.MODULE$.get(actorSystem);
    }

    public static DistributedPubSub get(ClassicActorSystemProvider classicActorSystemProvider) {
        return DistributedPubSub$.MODULE$.get(classicActorSystemProvider);
    }

    public static /* synthetic */ Extension get(ClassicActorSystemProvider classicActorSystemProvider) {
        return DistributedPubSub$.MODULE$.get(classicActorSystemProvider);
    }

    public static ExtensionId<? extends Extension> lookup() {
        return DistributedPubSub$.MODULE$.lookup();
    }

    public DistributedPubSub(ExtendedActorSystem system) {
        ActorRef actorRef;
        this.system = system;
        this.settings = DistributedPubSubSettings$.MODULE$.apply((ActorSystem)system);
        if (this.isTerminated()) {
            actorRef = system.deadLetters();
        } else {
            String name = system.settings().config().getString("pekko.cluster.pub-sub.name");
            String dispatcher = system.settings().config().getString("pekko.cluster.pub-sub.use-dispatcher");
            actorRef = system.systemActorOf(DistributedPubSubMediator$.MODULE$.props(this.settings).withDispatcher(dispatcher), name);
        }
        this.mediator = actorRef;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean isTerminated() {
        if (((Cluster)Cluster$.MODULE$.apply((ActorSystem)this.system)).isTerminated()) return true;
        Set set = ((Cluster)Cluster$.MODULE$.apply((ActorSystem)this.system)).selfRoles();
        if (this.settings.role().forall((Function1 & Serializable)elem -> set.contains(elem))) return false;
        return true;
    }

    public ActorRef mediator() {
        return this.mediator;
    }
}

