/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pekko.cluster.client;

import com.typesafe.config.Config;
import org.apache.pekko.actor.ActorRef;
import org.apache.pekko.actor.ActorSystem;
import org.apache.pekko.actor.ClassicActorSystemProvider;
import org.apache.pekko.actor.ExtendedActorSystem;
import org.apache.pekko.actor.Extension;
import org.apache.pekko.actor.ExtensionId;
import org.apache.pekko.cluster.Cluster;
import org.apache.pekko.cluster.Cluster$;
import org.apache.pekko.cluster.client.ClusterClientReceptionist$;
import org.apache.pekko.cluster.client.ClusterReceptionist$;
import org.apache.pekko.cluster.client.ClusterReceptionistSettings$;
import org.apache.pekko.cluster.pubsub.DistributedPubSub;
import org.apache.pekko.cluster.pubsub.DistributedPubSub$;
import org.apache.pekko.cluster.pubsub.DistributedPubSubMediator;
import org.apache.pekko.cluster.pubsub.DistributedPubSubMediator$Put$;
import org.apache.pekko.cluster.pubsub.DistributedPubSubMediator$Remove$;
import org.apache.pekko.cluster.pubsub.DistributedPubSubMediator$Subscribe$;
import org.apache.pekko.cluster.pubsub.DistributedPubSubMediator$Unsubscribe$;
import scala.None$;
import scala.Option;
import scala.Some$;
import scala.collection.immutable.Set;

public final class ClusterClientReceptionist
implements Extension {
    private final ExtendedActorSystem system;
    private final Option<String> role;
    private final ActorRef receptionist;

    public static Extension apply(ActorSystem actorSystem) {
        return ClusterClientReceptionist$.MODULE$.apply(actorSystem);
    }

    public static Extension apply(ClassicActorSystemProvider classicActorSystemProvider) {
        return ClusterClientReceptionist$.MODULE$.apply(classicActorSystemProvider);
    }

    public static ClusterClientReceptionist createExtension(ExtendedActorSystem extendedActorSystem) {
        return ClusterClientReceptionist$.MODULE$.createExtension(extendedActorSystem);
    }

    public static ClusterClientReceptionist get(ActorSystem actorSystem) {
        return ClusterClientReceptionist$.MODULE$.get(actorSystem);
    }

    public static /* synthetic */ Extension get(ActorSystem actorSystem) {
        return ClusterClientReceptionist$.MODULE$.get(actorSystem);
    }

    public static ClusterClientReceptionist get(ClassicActorSystemProvider classicActorSystemProvider) {
        return ClusterClientReceptionist$.MODULE$.get(classicActorSystemProvider);
    }

    public static /* synthetic */ Extension get(ClassicActorSystemProvider classicActorSystemProvider) {
        return ClusterClientReceptionist$.MODULE$.get(classicActorSystemProvider);
    }

    public static ExtensionId<? extends Extension> lookup() {
        return ClusterClientReceptionist$.MODULE$.lookup();
    }

    public ClusterClientReceptionist(ExtendedActorSystem system) {
        ActorRef actorRef;
        None$ none$;
        this.system = system;
        Config config = system.settings().config().getConfig("pekko.cluster.client.receptionist");
        String string = config.getString("role");
        if ("".equals(string)) {
            none$ = None$.MODULE$;
        } else {
            String r = string;
            none$ = this.role = Some$.MODULE$.apply((Object)r);
        }
        if (this.isTerminated()) {
            actorRef = system.deadLetters();
        } else {
            String name = config.getString("name");
            String dispatcher = config.getString("use-dispatcher");
            ActorRef mediator = this.pubSubMediator();
            actorRef = system.systemActorOf(ClusterReceptionist$.MODULE$.props(mediator, ClusterReceptionistSettings$.MODULE$.apply(config)).withDispatcher(dispatcher), name);
        }
        this.receptionist = actorRef;
    }

    public boolean isTerminated() {
        Set set;
        return ((Cluster)Cluster$.MODULE$.apply((ActorSystem)this.system)).isTerminated() || !this.role.forall(arg_0 -> ClusterClientReceptionist.isTerminated$$anonfun$1(set = ((Cluster)Cluster$.MODULE$.apply((ActorSystem)this.system)).selfRoles(), arg_0));
    }

    private ActorRef pubSubMediator() {
        return ((DistributedPubSub)DistributedPubSub$.MODULE$.apply((ActorSystem)this.system)).mediator();
    }

    public void registerService(ActorRef actor) {
        ActorRef actorRef = this.pubSubMediator();
        DistributedPubSubMediator.Put put = DistributedPubSubMediator$Put$.MODULE$.apply(actor);
        actorRef.$bang((Object)put, actorRef.$bang$default$2((Object)put));
    }

    public void unregisterService(ActorRef actor) {
        ActorRef actorRef = this.pubSubMediator();
        DistributedPubSubMediator.Remove remove = DistributedPubSubMediator$Remove$.MODULE$.apply(actor.path().toStringWithoutAddress());
        actorRef.$bang((Object)remove, actorRef.$bang$default$2((Object)remove));
    }

    public void registerSubscriber(String topic, ActorRef actor) {
        ActorRef actorRef = this.pubSubMediator();
        DistributedPubSubMediator.Subscribe subscribe = DistributedPubSubMediator$Subscribe$.MODULE$.apply(topic, actor);
        actorRef.$bang((Object)subscribe, actorRef.$bang$default$2((Object)subscribe));
    }

    public void unregisterSubscriber(String topic, ActorRef actor) {
        ActorRef actorRef = this.pubSubMediator();
        DistributedPubSubMediator.Unsubscribe unsubscribe = DistributedPubSubMediator$Unsubscribe$.MODULE$.apply(topic, actor);
        actorRef.$bang((Object)unsubscribe, actorRef.$bang$default$2((Object)unsubscribe));
    }

    public ActorRef underlying() {
        return this.receptionist;
    }

    private static final /* synthetic */ boolean isTerminated$$anonfun$1(Set $1$$1, String elem) {
        return $1$$1.contains((Object)elem);
    }
}

