/*
 * Decompiled with CFR 0.152.
 */
package org.apache.parquet.cli.util;

import java.util.Locale;
import org.apache.parquet.hadoop.metadata.CompressionCodecName;
import shaded.parquet.org.apache.avro.AvroRuntimeException;
import shaded.parquet.org.apache.avro.file.CodecFactory;

public class Codecs {
    public static CompressionCodecName parquetCodec(String codec) {
        try {
            return CompressionCodecName.valueOf(codec.toUpperCase(Locale.ENGLISH));
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException("Unknown compression codec: " + codec);
        }
    }

    public static CodecFactory avroCodec(String codec) {
        CodecFactory factory;
        String avroCodec = codec.equalsIgnoreCase(CompressionCodecName.GZIP.name()) ? "deflate" : (codec.equalsIgnoreCase(CompressionCodecName.SNAPPY.name()) ? "snappy" : (codec.equalsIgnoreCase(CompressionCodecName.UNCOMPRESSED.name()) ? "null" : (codec.equalsIgnoreCase(CompressionCodecName.ZSTD.name()) ? "zstandard" : codec)));
        try {
            factory = CodecFactory.fromString(avroCodec);
        }
        catch (AvroRuntimeException e) {
            throw new IllegalArgumentException("Codec incompatible with Avro: " + codec, e);
        }
        return factory;
    }
}

