/*
 * Decompiled with CFR 0.152.
 */
package org.apache.parquet.cli.json;

import com.google.common.collect.Iterators;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.util.Iterator;
import org.apache.parquet.cli.json.AvroJson;
import org.apache.parquet.cli.util.RuntimeIOException;
import shaded.parquet.org.apache.avro.Schema;
import shaded.parquet.org.apache.avro.generic.GenericData;

public class AvroJsonReader<E>
implements Iterator<E>,
Iterable<E>,
Closeable {
    private final GenericData model;
    private final Schema schema;
    private final InputStream stream;
    private Iterator<E> iterator;

    public AvroJsonReader(InputStream stream, Schema schema) {
        this.stream = stream;
        this.schema = schema;
        this.model = GenericData.get();
        this.iterator = Iterators.transform(AvroJson.parser(stream), node -> AvroJson.convertToAvro(this.model, node, this.schema));
    }

    @Override
    public boolean hasNext() {
        return this.iterator.hasNext();
    }

    @Override
    public E next() {
        return this.iterator.next();
    }

    @Override
    public void close() {
        this.iterator = null;
        try {
            this.stream.close();
        }
        catch (IOException e) {
            throw new RuntimeIOException("Cannot close reader", e);
        }
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("Remove is not implemented.");
    }

    @Override
    public Iterator<E> iterator() {
        return this;
    }
}

