/*
 * Decompiled with CFR 0.152.
 */
package org.apache.parquet.cli.commands;

import com.beust.jcommander.Parameter;
import com.beust.jcommander.Parameters;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.List;
import java.util.Optional;
import org.apache.commons.text.TextStringBuilder;
import org.apache.parquet.cli.BaseCommand;
import org.apache.parquet.cli.Util;
import org.apache.parquet.column.values.bloomfilter.BloomFilter;
import org.apache.parquet.hadoop.BloomFilterReader;
import org.apache.parquet.hadoop.ParquetFileReader;
import org.apache.parquet.hadoop.metadata.BlockMetaData;
import org.apache.parquet.hadoop.metadata.ColumnChunkMetaData;
import org.apache.parquet.hadoop.util.HadoopInputFile;
import org.apache.parquet.io.api.Binary;
import org.apache.parquet.schema.MessageType;
import org.apache.parquet.schema.PrimitiveType;
import org.slf4j.Logger;

@Parameters(commandDescription="Check bloom filters for a Parquet column")
public class ShowBloomFilterCommand
extends BaseCommand {
    @Parameter(description="<parquet path>")
    String file;
    @Parameter(names={"-c", "--column"}, description="Check the bloom filter indexes for the given column", required=true)
    String columnPath;
    @Parameter(names={"-v", "--values"}, description="Check if the given values match bloom filter", required=true)
    List<String> testValues;

    public ShowBloomFilterCommand(Logger console) {
        super(console);
    }

    @Override
    public int run() throws IOException {
        Preconditions.checkArgument((this.file != null ? 1 : 0) != 0, (Object)"A Parquet file is required.");
        HadoopInputFile in = HadoopInputFile.fromPath(this.qualifiedPath(this.file), this.getConf());
        try (ParquetFileReader reader = ParquetFileReader.open(in);){
            MessageType schema = reader.getFileMetaData().getSchema();
            PrimitiveType type = Util.primitive(this.columnPath, schema);
            int rowGroupIndex = 0;
            for (BlockMetaData block : reader.getFooter().getBlocks()) {
                this.console.info(String.format("\nRow group %d: \n%s", rowGroupIndex, new TextStringBuilder(80).appendPadding(80, '-')));
                Optional<ColumnChunkMetaData> maybeColumnMeta = block.getColumns().stream().filter(c -> this.columnPath.equals(c.getPath().toDotString())).findFirst();
                if (!maybeColumnMeta.isPresent()) {
                    this.console.info("column {} doesn't exist.", (Object)this.columnPath);
                } else {
                    BloomFilterReader bloomFilterReader = reader.getBloomFilterDataReader(block);
                    BloomFilter bloomFilter = bloomFilterReader.readBloomFilter(maybeColumnMeta.get());
                    if (bloomFilter == null) {
                        this.console.info("column {} has no bloom filter", (Object)this.columnPath);
                    } else {
                        for (String value : this.testValues) {
                            if (bloomFilter.findHash(bloomFilter.hash(this.getOriginalType(value, type)))) {
                                this.console.info("value {} maybe exists.", (Object)value);
                                continue;
                            }
                            this.console.info("value {} NOT exists.", (Object)value);
                        }
                    }
                }
                ++rowGroupIndex;
            }
        }
        return 0;
    }

    private Object getOriginalType(String value, PrimitiveType type) {
        switch (type.getPrimitiveTypeName()) {
            case BINARY: {
                return Binary.fromString(value);
            }
            case INT32: {
                return Integer.valueOf(value);
            }
            case INT64: {
                return Long.valueOf(value);
            }
            case FLOAT: {
                return Float.valueOf(value);
            }
            case DOUBLE: {
                return Double.valueOf(value);
            }
        }
        throw new IllegalArgumentException("Unknown type: " + (Object)((Object)type.getPrimitiveTypeName()));
    }

    @Override
    public List<String> getExamples() {
        return Lists.newArrayList((Object[])new String[]{"# Show bloom filter for column 'col' from a Parquet file", "-c col -v 1,2,3 -i sample.parquet"});
    }
}

