/*
 * Decompiled with CFR 0.152.
 */
package org.apache.parquet.cli.commands;

import com.beust.jcommander.Parameter;
import com.beust.jcommander.Parameters;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.io.Closeables;
import java.io.Closeable;
import java.io.IOException;
import java.util.List;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.parquet.avro.AvroParquetWriter;
import org.apache.parquet.cli.BaseCommand;
import org.apache.parquet.cli.util.Codecs;
import org.apache.parquet.cli.util.Expressions;
import org.apache.parquet.cli.util.Schemas;
import org.apache.parquet.column.ParquetProperties;
import org.apache.parquet.hadoop.ParquetWriter;
import org.apache.parquet.hadoop.metadata.CompressionCodecName;
import org.slf4j.Logger;
import shaded.parquet.org.apache.avro.Schema;
import shaded.parquet.org.apache.avro.generic.GenericData;

@Parameters(commandDescription="Create a Parquet file from a data file")
public class ConvertCommand
extends BaseCommand {
    @Parameter(description="<file>")
    List<String> targets;
    @Parameter(names={"-o", "--output"}, description="Output file path", required=true)
    String outputPath = null;
    @Parameter(names={"-s", "--schema"}, description="The file containing the Avro schema.")
    String avroSchemaFile;
    @Parameter(names={"-c", "--column", "--columns"}, description="List of columns")
    List<String> columns;
    @Parameter(names={"--compression-codec"}, description="A compression codec name.")
    String compressionCodecName = "GZIP";
    @Parameter(names={"--overwrite"}, description="Overwrite the output file if it exists")
    boolean overwrite = false;
    @Parameter(names={"-2", "--format-version-2", "--writer-version-2"}, description="Use Parquet format version 2", hidden=true)
    boolean v2 = false;
    @Parameter(names={"--row-group-size"}, description="Target row group size")
    int rowGroupSize = 0x8000000;
    @Parameter(names={"--page-size"}, description="Target page size")
    int pageSize = 0x100000;
    @Parameter(names={"--dictionary-size"}, description="Max dictionary page size")
    int dictionaryPageSize = 0x100000;

    public ConvertCommand(Logger console) {
        super(console);
    }

    @Override
    public int run() throws IOException {
        Preconditions.checkArgument((this.targets != null && this.targets.size() == 1 ? 1 : 0) != 0, (Object)"A data file is required.");
        String source = this.targets.get(0);
        CompressionCodecName codec = Codecs.parquetCodec(this.compressionCodecName);
        Schema schema = this.avroSchemaFile != null ? Schemas.fromAvsc(this.open(this.avroSchemaFile)) : this.getAvroSchema(source);
        Schema projection = Expressions.filterSchema(schema, this.columns);
        Path outPath = this.qualifiedPath(this.outputPath);
        FileSystem outFS = outPath.getFileSystem(this.getConf());
        if (this.overwrite && outFS.exists(outPath)) {
            this.console.debug("Deleting output file {} (already exists)", (Object)outPath);
            outFS.delete(outPath);
        }
        Iterable reader = this.openDataFile(source, projection);
        boolean threw = true;
        long count = 0L;
        try {
            try (ParquetWriter<GenericData.Record> writer = ((AvroParquetWriter.Builder)((AvroParquetWriter.Builder)((AvroParquetWriter.Builder)((AvroParquetWriter.Builder)((AvroParquetWriter.Builder)((AvroParquetWriter.Builder)((AvroParquetWriter.Builder)AvroParquetWriter.builder(this.qualifiedPath(this.outputPath)).withWriterVersion(this.v2 ? ParquetProperties.WriterVersion.PARQUET_2_0 : ParquetProperties.WriterVersion.PARQUET_1_0)).withConf(this.getConf())).withCompressionCodec(codec)).withRowGroupSize(this.rowGroupSize)).withDictionaryPageSize(this.dictionaryPageSize < 64 ? 64 : this.dictionaryPageSize)).withDictionaryEncoding(this.dictionaryPageSize != 0)).withPageSize(this.pageSize)).withDataModel(GenericData.get()).withSchema(projection).build();){
                for (GenericData.Record record : reader) {
                    writer.write(record);
                    ++count;
                }
            }
            threw = false;
        }
        catch (RuntimeException e) {
            throw new RuntimeException("Failed on record " + count, e);
        }
        finally {
            if (reader instanceof Closeable) {
                Closeables.close((Closeable)((Closeable)((Object)reader)), (boolean)threw);
            }
        }
        return 0;
    }

    @Override
    public List<String> getExamples() {
        return Lists.newArrayList((Object[])new String[]{"# Create a Parquet file from an Avro file", "sample.avro -o sample.parquet", "# Create a Parquet file in S3 from a local Avro file", "path/to/sample.avro -o s3:/user/me/sample.parquet", "# Create a Parquet file from Avro data in S3", "s3:/data/path/sample.avro -o sample.parquet"});
    }
}

