/*
 * Decompiled with CFR 0.152.
 */
package org.apache.parquet.cli;

import com.beust.jcommander.internal.Lists;
import com.google.common.base.Preconditions;
import com.google.common.io.CharStreams;
import com.google.common.io.Resources;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.security.AccessController;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import org.apache.hadoop.conf.Configurable;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.ChecksumFileSystem;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.LocalFileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.parquet.avro.AvroParquetReader;
import org.apache.parquet.avro.AvroReadSupport;
import org.apache.parquet.cli.Command;
import org.apache.parquet.cli.HadoopFileSystemURLStreamHandler;
import org.apache.parquet.cli.json.AvroJsonReader;
import org.apache.parquet.cli.util.Formats;
import org.apache.parquet.cli.util.GetClassLoader;
import org.apache.parquet.cli.util.Schemas;
import org.apache.parquet.cli.util.SeekableFSDataInputStream;
import org.apache.parquet.hadoop.ParquetReader;
import org.slf4j.Logger;
import shaded.parquet.org.apache.avro.Schema;
import shaded.parquet.org.apache.avro.file.DataFileReader;
import shaded.parquet.org.apache.avro.file.FileReader;
import shaded.parquet.org.apache.avro.file.SeekableInput;
import shaded.parquet.org.apache.avro.generic.GenericData;
import shaded.parquet.org.apache.avro.generic.GenericDatumReader;

public abstract class BaseCommand
implements Command,
Configurable {
    private static final String RESOURCE_URI_SCHEME = "resource";
    private static final String STDIN_AS_SOURCE = "stdin";
    protected final Logger console;
    private Configuration conf = null;
    private LocalFileSystem localFS = null;

    public BaseCommand(Logger console) {
        this.console = console;
    }

    public FileSystem defaultFS() throws IOException {
        if (this.localFS == null) {
            this.localFS = FileSystem.getLocal((Configuration)this.getConf());
        }
        return this.localFS;
    }

    public void output(String content, Logger console, String filename) throws IOException {
        if (filename == null || "-".equals(filename)) {
            console.info(content);
        } else {
            try (FSDataOutputStream outgoing = this.create(filename);){
                outgoing.write(content.getBytes(StandardCharsets.UTF_8));
                outgoing.flush();
            }
        }
    }

    public FSDataOutputStream create(String filename) throws IOException {
        return this.create(filename, true);
    }

    public FSDataOutputStream createWithChecksum(String filename) throws IOException {
        return this.create(filename, false);
    }

    public FSDataOutputStream createWithNoOverwrite(String filename) throws IOException {
        return this.create(filename, true, false);
    }

    private FSDataOutputStream create(String filename, boolean noChecksum) throws IOException {
        return this.create(filename, noChecksum, true);
    }

    private FSDataOutputStream create(String filename, boolean noChecksum, boolean overwrite) throws IOException {
        Path filePath = this.qualifiedPath(filename);
        FileSystem fs = filePath.getFileSystem(this.getConf());
        if (noChecksum && fs instanceof ChecksumFileSystem) {
            fs = ((ChecksumFileSystem)fs).getRawFileSystem();
        }
        return fs.create(filePath, overwrite);
    }

    public Path qualifiedPath(String filename) throws IOException {
        Path cwd = this.defaultFS().makeQualified(new Path("."));
        return new Path(filename).makeQualified(this.defaultFS().getUri(), cwd);
    }

    public URI qualifiedURI(String filename) throws IOException {
        try {
            URI fileURI = new URI(filename);
            if (RESOURCE_URI_SCHEME.equals(fileURI.getScheme())) {
                return fileURI;
            }
        }
        catch (URISyntaxException uRISyntaxException) {
            // empty catch block
        }
        return this.qualifiedPath(filename).toUri();
    }

    public InputStream open(String filename) throws IOException {
        if (STDIN_AS_SOURCE.equals(filename)) {
            return System.in;
        }
        URI uri = this.qualifiedURI(filename);
        if (RESOURCE_URI_SCHEME.equals(uri.getScheme())) {
            return Resources.getResource((String)uri.getRawSchemeSpecificPart()).openStream();
        }
        Path filePath = new Path(uri);
        FileSystem fs = filePath.getFileSystem(this.getConf());
        return fs.open(filePath);
    }

    public SeekableInput openSeekable(String filename) throws IOException {
        Path path = this.qualifiedPath(filename);
        FileSystem fs = path.getFileSystem(this.getConf());
        return new SeekableFSDataInputStream(fs, path);
    }

    public void setConf(Configuration conf) {
        this.conf = conf;
        HadoopFileSystemURLStreamHandler.setDefaultConf(conf);
    }

    public Configuration getConf() {
        return null != this.conf ? this.conf : this.createDefaultConf();
    }

    private Configuration createDefaultConf() {
        Configuration conf = new Configuration();
        conf.setBoolean("parquet.avro.readInt96AsFixed", true);
        return conf;
    }

    protected static ClassLoader loaderFor(List<String> jars, List<String> paths) throws MalformedURLException {
        return AccessController.doPrivileged(new GetClassLoader(BaseCommand.urls(jars, paths)));
    }

    protected static ClassLoader loaderForJars(List<String> jars) throws MalformedURLException {
        return AccessController.doPrivileged(new GetClassLoader(BaseCommand.urls(jars, null)));
    }

    protected static ClassLoader loaderForPaths(List<String> paths) throws MalformedURLException {
        return AccessController.doPrivileged(new GetClassLoader(BaseCommand.urls(null, paths)));
    }

    private static List<URL> urls(List<String> jars, List<String> dirs) throws MalformedURLException {
        File path;
        List<URL> urls = Lists.newArrayList();
        if (dirs != null) {
            for (String lib : dirs) {
                path = lib.endsWith("/") ? new File(lib) : new File(lib + "/");
                Preconditions.checkArgument((boolean)path.exists(), (String)"Lib directory does not exist: %s", (Object)lib);
                Preconditions.checkArgument((boolean)path.isDirectory(), (String)"Not a directory: %s", (Object)lib);
                Preconditions.checkArgument((path.canRead() && path.canExecute() ? 1 : 0) != 0, (String)"Insufficient permissions to access lib directory: %s", (Object)lib);
                urls.add(path.toURI().toURL());
            }
        }
        if (jars != null) {
            for (String jar : jars) {
                path = new File(jar);
                Preconditions.checkArgument((boolean)path.exists(), (String)"Jar files does not exist: %s", (Object)jar);
                Preconditions.checkArgument((boolean)path.isFile(), (String)"Not a file: %s", (Object)jar);
                Preconditions.checkArgument((boolean)path.canRead(), (String)"Cannot read jar file: %s", (Object)jar);
                urls.add(path.toURI().toURL());
            }
        }
        return urls;
    }

    protected <D> Iterable<D> openDataFile(final String source, Schema projection) throws IOException {
        Formats.Format format = Formats.detectFormat(this.open(source));
        switch (format) {
            case PARQUET: {
                Configuration conf = new Configuration(this.getConf());
                AvroReadSupport.setRequestedProjection(conf, projection);
                AvroReadSupport.setAvroReadSchema(conf, projection);
                final ParquetReader parquet = AvroParquetReader.builder(this.qualifiedPath(source)).disableCompatibility().withDataModel(GenericData.get()).withConf(conf).build();
                return new Iterable<D>(){

                    @Override
                    public Iterator<D> iterator() {
                        return new Iterator<D>(){
                            private boolean hasNext = false;
                            private D next = this.advance();

                            @Override
                            public boolean hasNext() {
                                return this.hasNext;
                            }

                            @Override
                            public D next() {
                                if (!this.hasNext) {
                                    throw new NoSuchElementException();
                                }
                                Object toReturn = this.next;
                                this.next = this.advance();
                                return toReturn;
                            }

                            private D advance() {
                                try {
                                    Object next = parquet.read();
                                    this.hasNext = next != null;
                                    return next;
                                }
                                catch (IOException e) {
                                    throw new RuntimeException("Failed while reading Parquet file: " + source, e);
                                }
                            }

                            @Override
                            public void remove() {
                                throw new UnsupportedOperationException("Remove is not supported");
                            }
                        };
                    }
                };
            }
            case AVRO: {
                FileReader avroReader = DataFileReader.openReader(this.openSeekable(source), new GenericDatumReader(projection));
                return avroReader;
            }
        }
        if (source.endsWith("json")) {
            return new AvroJsonReader(this.open(source), projection);
        }
        Preconditions.checkArgument((projection == null ? 1 : 0) != 0, (Object)"Cannot select columns from text files");
        List text = CharStreams.readLines((Readable)new InputStreamReader(this.open(source)));
        return text;
    }

    protected Schema getAvroSchema(String source) throws IOException {
        Throwable throwable = null;
        try (SeekableInput in = this.openSeekable(source);){
            Formats.Format format = Formats.detectFormat((InputStream)((Object)in));
            in.seek(0L);
            switch (format) {
                case PARQUET: {
                    Schema schema = Schemas.fromParquet(this.getConf(), this.qualifiedURI(source));
                    return schema;
                }
                case AVRO: {
                    Schema schema = Schemas.fromAvro(this.open(source));
                    return schema;
                }
                case TEXT: {
                    if (source.endsWith("avsc")) {
                        Schema schema = Schemas.fromAvsc(this.open(source));
                        return schema;
                    }
                    if (!source.endsWith("json")) break;
                    Schema schema = Schemas.fromJSON("json", this.open(source));
                    return schema;
                }
            }
            try {
                throw new IllegalArgumentException(String.format("Could not determine file format of %s.", source));
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
        }
    }
}

