/*
 * Decompiled with CFR 0.152.
 */
package org.apache.parquet.avro;

import java.io.IOException;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.parquet.avro.AvroReadSupport;
import org.apache.parquet.conf.ParquetConfiguration;
import org.apache.parquet.filter.UnboundRecordFilter;
import org.apache.parquet.hadoop.ParquetReader;
import org.apache.parquet.hadoop.api.ReadSupport;
import org.apache.parquet.io.InputFile;
import shaded.parquet.org.apache.avro.generic.GenericData;
import shaded.parquet.org.apache.avro.generic.GenericRecord;
import shaded.parquet.org.apache.avro.specific.SpecificData;

public class AvroParquetReader<T>
extends ParquetReader<T> {
    @Deprecated
    public static <T> Builder<T> builder(Path file) {
        return new Builder(file);
    }

    public static <T> Builder<T> builder(InputFile file) {
        return new Builder(file);
    }

    public static <T> Builder<T> builder(InputFile file, ParquetConfiguration conf) {
        return new Builder(file, conf);
    }

    public static ParquetReader<GenericRecord> genericRecordReader(InputFile file) throws IOException {
        return new Builder(file).withDataModel(GenericData.get()).build();
    }

    public static ParquetReader<GenericRecord> genericRecordReader(InputFile file, ParquetConfiguration conf) throws IOException {
        return new Builder(file, conf).withDataModel(GenericData.get()).build();
    }

    @Deprecated
    public static ParquetReader<GenericRecord> genericRecordReader(Path file) throws IOException {
        return new Builder(file).withDataModel(GenericData.get()).build();
    }

    @Deprecated
    public AvroParquetReader(Path file) throws IOException {
        super(file, new AvroReadSupport());
    }

    @Deprecated
    public AvroParquetReader(Path file, UnboundRecordFilter unboundRecordFilter) throws IOException {
        super(file, new AvroReadSupport(), unboundRecordFilter);
    }

    @Deprecated
    public AvroParquetReader(Configuration conf, Path file) throws IOException {
        super(conf, file, new AvroReadSupport());
    }

    @Deprecated
    public AvroParquetReader(Configuration conf, Path file, UnboundRecordFilter unboundRecordFilter) throws IOException {
        super(conf, file, new AvroReadSupport(), unboundRecordFilter);
    }

    public static class Builder<T>
    extends ParquetReader.Builder<T> {
        private GenericData model = null;
        private boolean enableCompatibility = true;
        private boolean isReflect = true;

        @Deprecated
        private Builder(Path path) {
            super(path);
        }

        private Builder(InputFile file) {
            super(file);
        }

        private Builder(InputFile file, ParquetConfiguration conf) {
            super(file, conf);
        }

        public Builder<T> withDataModel(GenericData model) {
            this.model = model;
            if (model.getClass() != GenericData.class && model.getClass() != SpecificData.class) {
                this.isReflect = true;
            }
            return this;
        }

        public Builder<T> withSerializableClasses(String ... classNames) {
            if (classNames.length == 0) {
                this.configuration.set("parquet.avro.serializable.classes", null);
            } else {
                this.configuration.set("parquet.avro.serializable.classes", String.join((CharSequence)",", classNames));
            }
            return this;
        }

        public Builder<T> withSerializableClasses(Class<?> ... classes) {
            if (classes.length == 0) {
                this.configuration.set("parquet.avro.serializable.classes", null);
            } else {
                this.configuration.set("parquet.avro.serializable.classes", Stream.of(classes).map(Class::getName).collect(Collectors.joining(",")));
            }
            return this;
        }

        public Builder<T> disableCompatibility() {
            this.enableCompatibility = false;
            return this;
        }

        public Builder<T> withCompatibility(boolean enableCompatibility) {
            this.enableCompatibility = enableCompatibility;
            return this;
        }

        @Override
        protected ReadSupport<T> getReadSupport() {
            if (this.isReflect) {
                this.configuration.setBoolean("parquet.avro.compatible", false);
            } else {
                this.configuration.setBoolean("parquet.avro.compatible", this.enableCompatibility);
            }
            return new AvroReadSupport(this.model);
        }
    }
}

