/*
 * Decompiled with CFR 0.152.
 */
package org.apache.parquet.cli.commands;

import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import org.apache.hadoop.conf.Configuration;
import org.apache.parquet.cli.commands.ParquetFileTest;
import org.apache.parquet.cli.commands.ShowDictionaryCommand;
import org.junit.Assert;
import org.junit.Test;

public class ShowDictionaryCommandTest
extends ParquetFileTest {
    @Test
    public void testShowDirectoryCommand() throws IOException {
        File file = this.parquetFile();
        ShowDictionaryCommand command = new ShowDictionaryCommand(ShowDictionaryCommandTest.createLogger());
        command.targets = Arrays.asList(file.getAbsolutePath());
        command.column = "binary_field";
        command.setConf(new Configuration());
        Assert.assertEquals((long)0L, (long)command.run());
    }

    @Test
    public void testShowDirectoryCommandWithoutDictionaryEncoding() throws IOException {
        File file = this.parquetFile();
        ShowDictionaryCommand command = new ShowDictionaryCommand(ShowDictionaryCommandTest.createLogger());
        command.targets = Arrays.asList(file.getAbsolutePath());
        command.column = "double_field";
        command.setConf(new Configuration());
        Assert.assertEquals((long)0L, (long)command.run());
    }

    @Test
    public void testShowDirectoryCommandForFixedLengthByteArray() throws IOException {
        File file = this.parquetFile();
        ShowDictionaryCommand command = new ShowDictionaryCommand(ShowDictionaryCommandTest.createLogger());
        command.targets = Arrays.asList(file.getAbsolutePath());
        command.column = "flba_field";
        command.setConf(new Configuration());
        Assert.assertEquals((long)0L, (long)command.run());
    }
}

