/*
 * Decompiled with CFR 0.152.
 */
package org.apache.parquet.cli.commands;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileAlreadyExistsException;
import org.apache.parquet.cli.commands.ParquetFileTest;
import org.apache.parquet.cli.commands.RewriteCommand;
import org.junit.Assert;
import org.junit.Test;

public class RewriteCommandTest
extends ParquetFileTest {
    @Test
    public void testRewriteCommand() throws IOException {
        File file = this.parquetFile();
        RewriteCommand command = new RewriteCommand(RewriteCommandTest.createLogger());
        command.inputs = Arrays.asList(file.getAbsolutePath());
        File output = new File(this.getTempFolder(), "converted.parquet");
        command.output = output.getAbsolutePath();
        command.setConf(new Configuration());
        Assert.assertEquals((long)0L, (long)command.run());
        Assert.assertTrue((boolean)output.exists());
    }

    @Test(expected=FileAlreadyExistsException.class)
    public void testRewriteCommandWithoutOverwrite() throws IOException {
        File file = this.parquetFile();
        RewriteCommand command = new RewriteCommand(RewriteCommandTest.createLogger());
        command.inputs = Arrays.asList(file.getAbsolutePath());
        File output = new File(this.getTempFolder(), "converted.parquet");
        command.output = output.getAbsolutePath();
        command.setConf(new Configuration());
        Files.createFile(output.toPath(), new FileAttribute[0]);
        command.run();
    }

    @Test
    public void testRewriteCommandWithOverwrite() throws IOException {
        File file = this.parquetFile();
        RewriteCommand command = new RewriteCommand(RewriteCommandTest.createLogger());
        command.inputs = Arrays.asList(file.getAbsolutePath());
        File output = new File(this.getTempFolder(), "converted.parquet");
        command.output = output.getAbsolutePath();
        command.overwrite = true;
        command.setConf(new Configuration());
        Files.createFile(output.toPath(), new FileAttribute[0]);
        Assert.assertEquals((long)0L, (long)command.run());
        Assert.assertTrue((boolean)output.exists());
    }
}

