/*
 * Decompiled with CFR 0.152.
 */
package org.apache.parquet.cli.commands;

import java.io.File;
import java.io.IOException;
import java.util.Random;
import java.util.concurrent.ThreadLocalRandom;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.parquet.cli.commands.FileTest;
import org.apache.parquet.column.ParquetProperties;
import org.apache.parquet.example.data.simple.SimpleGroupFactory;
import org.apache.parquet.hadoop.ParquetWriter;
import org.apache.parquet.hadoop.api.WriteSupport;
import org.apache.parquet.hadoop.example.GroupWriteSupport;
import org.apache.parquet.hadoop.metadata.CompressionCodecName;
import org.apache.parquet.io.api.Binary;
import org.apache.parquet.schema.LogicalTypeAnnotation;
import org.apache.parquet.schema.MessageType;
import org.apache.parquet.schema.PrimitiveType;
import org.apache.parquet.schema.Types;
import org.junit.Before;

public abstract class ParquetFileTest
extends FileTest {
    private Random rnd = new Random();

    @Before
    public void setUp() throws IOException {
        this.createTestParquetFile();
    }

    protected File parquetFile() {
        File tmpDir = this.getTempFolder();
        return new File(tmpDir, this.getClass().getSimpleName() + ".parquet");
    }

    protected File randomParquetFile() {
        File tmpDir = this.getTempFolder();
        return new File(tmpDir, this.getClass().getSimpleName() + this.rnd.nextLong() + ".parquet");
    }

    private static MessageType createSchema() {
        return (MessageType)((Types.GroupBuilder)((Types.PrimitiveBuilder)((Types.GroupBuilder)((Types.PrimitiveBuilder)((Types.GroupBuilder)((Types.GroupBuilder)((Types.GroupBuilder)((Types.GroupBuilder)((Types.GroupBuilder)Types.buildMessage().required(PrimitiveType.PrimitiveTypeName.INT32).named("int32_field")).required(PrimitiveType.PrimitiveTypeName.INT64).named("int64_field")).required(PrimitiveType.PrimitiveTypeName.FLOAT).named("float_field")).required(PrimitiveType.PrimitiveTypeName.DOUBLE).named("double_field")).required(PrimitiveType.PrimitiveTypeName.BINARY).named("binary_field")).required(PrimitiveType.PrimitiveTypeName.FIXED_LEN_BYTE_ARRAY).length(12)).named("flba_field")).required(PrimitiveType.PrimitiveTypeName.INT32).as((LogicalTypeAnnotation)LogicalTypeAnnotation.dateType())).named("date_field")).named("schema");
    }

    private void createTestParquetFile() throws IOException {
        File file = this.parquetFile();
        Path fsPath = new Path(file.getPath());
        Configuration conf = new Configuration();
        MessageType schema = ParquetFileTest.createSchema();
        SimpleGroupFactory fact = new SimpleGroupFactory(schema);
        GroupWriteSupport.setSchema((MessageType)schema, (Configuration)conf);
        try (ParquetWriter writer = new ParquetWriter(fsPath, (WriteSupport)new GroupWriteSupport(), CompressionCodecName.UNCOMPRESSED, 1024, 1024, 512, true, false, ParquetProperties.WriterVersion.PARQUET_2_0, conf);){
            for (int i = 0; i < 10; ++i) {
                byte[] bytes = new byte[12];
                ThreadLocalRandom.current().nextBytes(bytes);
                writer.write((Object)fact.newGroup().append("int32_field", 32 + i).append("int64_field", 64L + (long)i).append("float_field", 1.0f + (float)i).append("double_field", 2.0 + (double)i).append("binary_field", Binary.fromString((String)COLORS[i % COLORS.length])).append("flba_field", Binary.fromConstantByteArray((byte[])bytes)).append("date_field", i));
            }
        }
    }
}

