/*
 * Decompiled with CFR 0.152.
 */
package org.apache.parquet.cli.commands;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import org.apache.parquet.cli.commands.FileTest;
import org.junit.Before;

public abstract class CSVFileTest
extends FileTest {
    @Before
    public void setUp() throws IOException {
        this.createTestCSVFile();
        this.createTestCSVFileWithDifferentSchema();
    }

    protected File csvFile() {
        File tmpDir = this.getTempFolder();
        return new File(tmpDir, this.getClass().getSimpleName() + ".csv");
    }

    protected File csvFileWithDifferentSchema() {
        File tmpDir = this.getTempFolder();
        return new File(tmpDir, this.getClass().getSimpleName() + "2.csv");
    }

    private void createTestCSVFile() throws IOException {
        File file = this.csvFile();
        try (BufferedWriter writer = new BufferedWriter(new FileWriter(file));){
            writer.write(String.format("%s,%s,%s\n", "int32_field", "int64_field", "binary_field"));
            writer.write(String.format("%d,%d,\"%s\"\n", Integer.MIN_VALUE, Long.MIN_VALUE, COLORS[0]));
            writer.write(String.format("%d,%d,\"%s\"\n", Integer.MAX_VALUE, Long.MAX_VALUE, COLORS[1]));
        }
    }

    private void createTestCSVFileWithDifferentSchema() throws IOException {
        File file = this.csvFileWithDifferentSchema();
        try (BufferedWriter writer = new BufferedWriter(new FileWriter(file));){
            writer.write(String.format("%s,%s,%s\n", "float_field", "double_field", "binary_field"));
            writer.write(String.format("%f,%f,\"%s\"\n", Float.valueOf(Float.MIN_VALUE), Double.MIN_VALUE, COLORS[0]));
            writer.write(String.format("%f,%f,\"%s\"\n", Float.valueOf(Float.MAX_VALUE), Double.MAX_VALUE, COLORS[1]));
        }
    }
}

