/*
 * Decompiled with CFR 0.152.
 */
package org.apache.parquet.cli.commands;

import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import org.apache.hadoop.conf.Configuration;
import org.apache.parquet.cli.commands.ParquetFileTest;
import org.apache.parquet.cli.commands.ToAvroCommand;

public class AvroFileTest
extends ParquetFileTest {
    protected File toAvro(File inputFile) throws IOException {
        return this.toAvro(inputFile, "GZIP");
    }

    protected File toAvro(File inputFile, String compressionCodecName) throws IOException {
        File outputFile = new File(this.getTempFolder(), this.getClass().getSimpleName() + ".avro");
        return this.toAvro(inputFile, outputFile, false, compressionCodecName);
    }

    protected File toAvro(File inputFile, File outputFile, boolean overwrite) throws IOException {
        return this.toAvro(inputFile, outputFile, overwrite, "GZIP");
    }

    protected File toAvro(File inputFile, File outputFile, boolean overwrite, String compressionCodecName) throws IOException {
        ToAvroCommand command = new ToAvroCommand(AvroFileTest.createLogger());
        command.targets = Arrays.asList(inputFile.getAbsolutePath());
        command.outputPath = outputFile.getAbsolutePath();
        command.compressionCodecName = compressionCodecName;
        command.overwrite = overwrite;
        command.setConf(new Configuration());
        int exitCode = command.run();
        assert (exitCode == 0);
        return outputFile;
    }
}

