/*
 * Decompiled with CFR 0.152.
 */
package org.apache.parquet.cli.json;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.BinaryNode;
import com.fasterxml.jackson.databind.node.BooleanNode;
import com.fasterxml.jackson.databind.node.MissingNode;
import com.fasterxml.jackson.databind.node.NullNode;
import com.fasterxml.jackson.databind.node.NumericNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.databind.node.TextNode;
import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Iterators;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.parquet.cli.util.RecordException;
import org.apache.parquet.cli.util.RuntimeIOException;
import org.apache.parquet.cli.util.Schemas;
import shaded.parquet.org.apache.avro.AvroRuntimeException;
import shaded.parquet.org.apache.avro.Schema;
import shaded.parquet.org.apache.avro.generic.GenericData;

public class AvroJson {
    private static final ObjectMapper MAPPER = new ObjectMapper();
    private static final JsonFactory FACTORY = new JsonFactory(MAPPER);
    private static ImmutableMap<Schema.Type, Schema> PRIMITIVES = ImmutableMap.builder().put((Object)Schema.Type.NULL, (Object)Schema.create(Schema.Type.NULL)).put((Object)Schema.Type.BOOLEAN, (Object)Schema.create(Schema.Type.BOOLEAN)).put((Object)Schema.Type.INT, (Object)Schema.create(Schema.Type.INT)).put((Object)Schema.Type.LONG, (Object)Schema.create(Schema.Type.LONG)).put((Object)Schema.Type.FLOAT, (Object)Schema.create(Schema.Type.FLOAT)).put((Object)Schema.Type.DOUBLE, (Object)Schema.create(Schema.Type.DOUBLE)).build();

    public static Iterator<JsonNode> parser(InputStream stream) {
        try {
            JsonParser parser = FACTORY.createParser(stream);
            return parser.readValuesAs(JsonNode.class);
        }
        catch (IOException e) {
            throw new RuntimeIOException("Cannot read from stream", e);
        }
    }

    public static JsonNode parse(String json) {
        return AvroJson.parse(json, JsonNode.class);
    }

    public static <T> T parse(String json, Class<T> returnType) {
        try {
            return MAPPER.readValue(json, returnType);
        }
        catch (JsonParseException | JsonMappingException e) {
            throw new IllegalArgumentException("Invalid JSON", e);
        }
        catch (IOException e) {
            throw new RuntimeIOException("Cannot initialize JSON parser", e);
        }
    }

    public static JsonNode parse(InputStream json) {
        return AvroJson.parse(json, JsonNode.class);
    }

    public static <T> T parse(InputStream json, Class<T> returnType) {
        try {
            return MAPPER.readValue(json, returnType);
        }
        catch (JsonParseException | JsonMappingException e) {
            throw new IllegalArgumentException("Invalid JSON stream", e);
        }
        catch (IOException e) {
            throw new RuntimeIOException("Cannot initialize JSON parser", e);
        }
    }

    public static Object convertToAvro(GenericData model, JsonNode datum, Schema schema) {
        if (datum == null) {
            return null;
        }
        switch (schema.getType()) {
            case RECORD: {
                RecordException.check(datum.isObject(), "Cannot convert non-object to record: %s", datum);
                Object record = model.newRecord(null, schema);
                for (Schema.Field field : schema.getFields()) {
                    model.setField(record, field.name(), field.pos(), AvroJson.convertField(model, datum.get(field.name()), field));
                }
                return record;
            }
            case MAP: {
                RecordException.check(datum.isObject(), "Cannot convert non-object to map: %s", datum);
                LinkedHashMap map = Maps.newLinkedHashMap();
                Iterator<Map.Entry<String, JsonNode>> iter = datum.fields();
                while (iter.hasNext()) {
                    Map.Entry<String, JsonNode> entry = iter.next();
                    map.put(entry.getKey(), AvroJson.convertToAvro(model, entry.getValue(), schema.getValueType()));
                }
                return map;
            }
            case ARRAY: {
                RecordException.check(datum.isArray(), "Cannot convert to array: %s", datum);
                ArrayList list = Lists.newArrayListWithExpectedSize((int)datum.size());
                for (JsonNode element : datum) {
                    list.add(AvroJson.convertToAvro(model, element, schema.getElementType()));
                }
                return list;
            }
            case UNION: {
                return AvroJson.convertToAvro(model, datum, AvroJson.resolveUnion(datum, schema.getTypes()));
            }
            case BOOLEAN: {
                RecordException.check(datum.isBoolean(), "Cannot convert to boolean: %s", datum);
                return datum.booleanValue();
            }
            case FLOAT: {
                RecordException.check(datum.isFloat() || datum.isInt(), "Cannot convert to float: %s", datum);
                return Float.valueOf(datum.floatValue());
            }
            case DOUBLE: {
                RecordException.check(datum.isDouble() || datum.isFloat() || datum.isLong() || datum.isInt(), "Cannot convert to double: %s", datum);
                return datum.doubleValue();
            }
            case INT: {
                RecordException.check(datum.isInt(), "Cannot convert to int: %s", datum);
                return datum.intValue();
            }
            case LONG: {
                RecordException.check(datum.isLong() || datum.isInt(), "Cannot convert to long: %s", datum);
                return datum.longValue();
            }
            case STRING: {
                RecordException.check(datum.isTextual(), "Cannot convert to string: %s", datum);
                return datum.textValue();
            }
            case ENUM: {
                RecordException.check(datum.isTextual(), "Cannot convert to string: %s", datum);
                return model.createEnum(datum.textValue(), schema);
            }
            case BYTES: {
                RecordException.check(datum.isBinary(), "Cannot convert to binary: %s", datum);
                try {
                    return ByteBuffer.wrap(datum.binaryValue());
                }
                catch (IOException e) {
                    throw new RecordException("Failed to read JSON binary", e);
                }
            }
            case FIXED: {
                byte[] bytes;
                RecordException.check(datum.isBinary(), "Cannot convert to fixed: %s", datum);
                try {
                    bytes = datum.binaryValue();
                }
                catch (IOException e) {
                    throw new RecordException("Failed to read JSON binary", e);
                }
                RecordException.check(bytes.length < schema.getFixedSize(), "Binary data is too short: %s bytes for %s", bytes.length, schema);
                return model.createFixed(null, bytes, schema);
            }
            case NULL: {
                return null;
            }
        }
        throw new IllegalArgumentException("Unknown schema type: " + schema);
    }

    private static Object convertField(GenericData model, JsonNode datum, Schema.Field field) {
        try {
            Object value = AvroJson.convertToAvro(model, datum, field.schema());
            if (value != null || Schemas.nullOk(field.schema())) {
                return value;
            }
            return model.getDefaultValue(field);
        }
        catch (RecordException e) {
            throw new RecordException(String.format("Cannot convert field %s", field.name()), e);
        }
        catch (AvroRuntimeException e) {
            throw new RecordException(String.format("Field %s: cannot make %s value: '%s'", field.name(), field.schema(), datum), e);
        }
    }

    private static Schema resolveUnion(JsonNode datum, Collection<Schema> schemas) {
        HashSet primitives = Sets.newHashSet();
        ArrayList others = Lists.newArrayList();
        for (Schema schema : schemas) {
            if (PRIMITIVES.containsKey((Object)schema.getType())) {
                primitives.add(schema.getType());
                continue;
            }
            others.add(schema);
        }
        Schema primitiveSchema = null;
        if (datum == null || datum.isNull()) {
            primitiveSchema = AvroJson.closestPrimitive(primitives, Schema.Type.NULL);
        } else if (datum.isShort() || datum.isInt()) {
            primitiveSchema = AvroJson.closestPrimitive(primitives, Schema.Type.INT, Schema.Type.LONG, Schema.Type.FLOAT, Schema.Type.DOUBLE);
        } else if (datum.isLong()) {
            primitiveSchema = AvroJson.closestPrimitive(primitives, Schema.Type.LONG, Schema.Type.DOUBLE);
        } else if (datum.isFloat()) {
            primitiveSchema = AvroJson.closestPrimitive(primitives, Schema.Type.FLOAT, Schema.Type.DOUBLE);
        } else if (datum.isDouble()) {
            primitiveSchema = AvroJson.closestPrimitive(primitives, Schema.Type.DOUBLE);
        } else if (datum.isBoolean()) {
            primitiveSchema = AvroJson.closestPrimitive(primitives, Schema.Type.BOOLEAN);
        }
        if (primitiveSchema != null) {
            return primitiveSchema;
        }
        for (Schema schema : others) {
            if (!AvroJson.matches(datum, schema)) continue;
            return schema;
        }
        throw new RecordException(String.format("Cannot resolve union: %s not in %s", datum, schemas));
    }

    private static Schema closestPrimitive(Set<Schema.Type> possible, Schema.Type ... types) {
        for (Schema.Type type : types) {
            if (!possible.contains((Object)type) || !PRIMITIVES.containsKey((Object)type)) continue;
            return (Schema)PRIMITIVES.get((Object)type);
        }
        return null;
    }

    private static boolean matches(JsonNode datum, Schema schema) {
        switch (schema.getType()) {
            case RECORD: {
                if (!datum.isObject()) break;
                boolean missingField = false;
                for (Schema.Field field : schema.getFields()) {
                    if (datum.has(field.name()) || field.defaultVal() != null) continue;
                    missingField = true;
                    break;
                }
                if (missingField) break;
                return true;
            }
            case UNION: {
                if (AvroJson.resolveUnion(datum, schema.getTypes()) == null) break;
                return true;
            }
            case MAP: {
                if (!datum.isObject()) break;
                return true;
            }
            case ARRAY: {
                if (!datum.isArray()) break;
                return true;
            }
            case BOOLEAN: {
                if (!datum.isBoolean()) break;
                return true;
            }
            case FLOAT: {
                if (!datum.isFloat() && !datum.isInt()) break;
                return true;
            }
            case DOUBLE: {
                if (!datum.isDouble() && !datum.isFloat() && !datum.isLong() && !datum.isInt()) break;
                return true;
            }
            case INT: {
                if (!datum.isInt()) break;
                return true;
            }
            case LONG: {
                if (!datum.isLong() && !datum.isInt()) break;
                return true;
            }
            case STRING: {
                if (!datum.isTextual()) break;
                return true;
            }
            case ENUM: {
                if (!datum.isTextual() || !schema.hasEnumSymbol(datum.textValue())) break;
                return true;
            }
            case BYTES: 
            case FIXED: {
                if (!datum.isBinary()) break;
                return true;
            }
            case NULL: {
                if (datum != null && !datum.isNull()) break;
                return true;
            }
            default: {
                throw new IllegalArgumentException("Unsupported schema: " + schema);
            }
        }
        return false;
    }

    public static Schema inferSchema(InputStream incoming, final String name, int numRecords) {
        Iterator schemas = Iterators.transform(AvroJson.parser(incoming), (Function)new Function<JsonNode, Schema>(){

            public Schema apply(JsonNode node) {
                return AvroJson.inferSchema(node, name);
            }
        });
        if (!schemas.hasNext()) {
            return null;
        }
        Schema result = (Schema)schemas.next();
        for (int i = 1; schemas.hasNext() && i < numRecords; ++i) {
            result = Schemas.merge(result, (Schema)schemas.next());
        }
        return result;
    }

    public static Schema inferSchema(JsonNode node, String name) {
        return AvroJson.visit(node, new JsonSchemaVisitor(name));
    }

    public static Schema inferSchemaWithMaps(JsonNode node, String name) {
        return AvroJson.visit(node, new JsonSchemaVisitor(name).useMaps());
    }

    private static <T> T visit(JsonNode node, JsonTreeVisitor<T> visitor) {
        switch (node.getNodeType()) {
            case OBJECT: {
                Preconditions.checkArgument((boolean)(node instanceof ObjectNode), (String)"Expected instance of ObjectNode: %s", (Object)node);
                LinkedHashMap fields = Maps.newLinkedHashMap();
                Iterator<Map.Entry<String, JsonNode>> iter = node.fields();
                while (iter.hasNext()) {
                    Map.Entry<String, JsonNode> entry = iter.next();
                    visitor.recordLevels.push(entry.getKey());
                    fields.put(entry.getKey(), AvroJson.visit(entry.getValue(), visitor));
                    visitor.recordLevels.pop();
                }
                return visitor.object((ObjectNode)node, fields);
            }
            case ARRAY: {
                Preconditions.checkArgument((boolean)(node instanceof ArrayNode), (String)"Expected instance of ArrayNode: %s", (Object)node);
                ArrayList elements = Lists.newArrayListWithExpectedSize((int)node.size());
                for (JsonNode element : node) {
                    elements.add(AvroJson.visit(element, visitor));
                }
                return visitor.array((ArrayNode)node, elements);
            }
            case BINARY: {
                Preconditions.checkArgument((boolean)(node instanceof BinaryNode), (String)"Expected instance of BinaryNode: %s", (Object)node);
                return visitor.binary((BinaryNode)node);
            }
            case STRING: {
                Preconditions.checkArgument((boolean)(node instanceof TextNode), (String)"Expected instance of TextNode: %s", (Object)node);
                return visitor.text((TextNode)node);
            }
            case NUMBER: {
                Preconditions.checkArgument((boolean)(node instanceof NumericNode), (String)"Expected instance of NumericNode: %s", (Object)node);
                return visitor.number((NumericNode)node);
            }
            case BOOLEAN: {
                Preconditions.checkArgument((boolean)(node instanceof BooleanNode), (String)"Expected instance of BooleanNode: %s", (Object)node);
                return visitor.bool((BooleanNode)node);
            }
            case MISSING: {
                Preconditions.checkArgument((boolean)(node instanceof MissingNode), (String)"Expected instance of MissingNode: %s", (Object)node);
                return visitor.missing((MissingNode)node);
            }
            case NULL: {
                Preconditions.checkArgument((boolean)(node instanceof NullNode), (String)"Expected instance of NullNode: %s", (Object)node);
                return visitor.nullNode((NullNode)node);
            }
        }
        throw new IllegalArgumentException("Unknown node type: " + (Object)((Object)node.getNodeType()) + ": " + node);
    }

    private static abstract class JsonTreeVisitor<T> {
        protected LinkedList<String> recordLevels = Lists.newLinkedList();

        private JsonTreeVisitor() {
        }

        public T object(ObjectNode object, Map<String, T> fields) {
            return null;
        }

        public T array(ArrayNode array, List<T> elements) {
            return null;
        }

        public T binary(BinaryNode binary) {
            return null;
        }

        public T text(TextNode text) {
            return null;
        }

        public T number(NumericNode number) {
            return null;
        }

        public T bool(BooleanNode bool) {
            return null;
        }

        public T missing(MissingNode missing) {
            return null;
        }

        public T nullNode(NullNode nullNode) {
            return null;
        }
    }

    private static class JsonSchemaVisitor
    extends JsonTreeVisitor<Schema> {
        private static final Joiner DOT = Joiner.on((char)'.');
        private final String name;
        private boolean objectsToRecords = true;

        public JsonSchemaVisitor(String name) {
            this.name = name;
        }

        public JsonSchemaVisitor useMaps() {
            this.objectsToRecords = false;
            return this;
        }

        @Override
        public Schema object(ObjectNode object, Map<String, Schema> fields) {
            if (this.objectsToRecords || this.recordLevels.size() < 1) {
                ArrayList recordFields = Lists.newArrayListWithExpectedSize((int)fields.size());
                for (Map.Entry<String, Schema> entry : fields.entrySet()) {
                    recordFields.add(new Schema.Field(entry.getKey(), entry.getValue(), "Type inferred from '" + object.get(entry.getKey()) + "'", null));
                }
                Schema recordSchema = this.recordLevels.size() < 1 ? Schema.createRecord(this.name, null, null, false) : Schema.createRecord(DOT.join((Iterable)this.recordLevels), null, null, false);
                recordSchema.setFields(recordFields);
                return recordSchema;
            }
            switch (fields.size()) {
                case 0: {
                    return Schema.createMap(Schema.create(Schema.Type.NULL));
                }
                case 1: {
                    return Schema.createMap((Schema)Iterables.getOnlyElement(fields.values()));
                }
            }
            return Schema.createMap(Schemas.mergeOrUnion(fields.values()));
        }

        @Override
        public Schema array(ArrayNode ignored, List<Schema> elementSchemas) {
            switch (elementSchemas.size()) {
                case 0: {
                    return Schema.createArray(Schema.create(Schema.Type.NULL));
                }
                case 1: {
                    return Schema.createArray((Schema)Iterables.getOnlyElement(elementSchemas));
                }
            }
            return Schema.createArray(Schemas.mergeOrUnion(elementSchemas));
        }

        @Override
        public Schema binary(BinaryNode ignored) {
            return Schema.create(Schema.Type.BYTES);
        }

        @Override
        public Schema text(TextNode ignored) {
            return Schema.create(Schema.Type.STRING);
        }

        @Override
        public Schema number(NumericNode number) {
            if (number.isInt()) {
                return Schema.create(Schema.Type.INT);
            }
            if (number.isLong()) {
                return Schema.create(Schema.Type.LONG);
            }
            if (number.isFloat()) {
                return Schema.create(Schema.Type.FLOAT);
            }
            if (number.isDouble()) {
                return Schema.create(Schema.Type.DOUBLE);
            }
            throw new UnsupportedOperationException(number.getClass().getName() + " is not supported");
        }

        @Override
        public Schema bool(BooleanNode ignored) {
            return Schema.create(Schema.Type.BOOLEAN);
        }

        @Override
        public Schema nullNode(NullNode ignored) {
            return Schema.create(Schema.Type.NULL);
        }

        @Override
        public Schema missing(MissingNode ignored) {
            throw new UnsupportedOperationException("MissingNode is not supported.");
        }
    }
}

