/*
 * Decompiled with CFR 0.152.
 */
package org.apache.parquet.cli.csv;

import au.com.bytecode.opencsv.CSVParser;
import au.com.bytecode.opencsv.CSVReader;
import com.google.common.base.CharMatcher;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import java.util.Objects;
import java.util.Set;
import java.util.regex.Pattern;
import org.apache.parquet.cli.csv.CSVProperties;
import shaded.parquet.org.apache.avro.Schema;
import shaded.parquet.org.apache.avro.SchemaBuilder;

public class AvroCSV {
    private static final Pattern LONG = Pattern.compile("\\d+");
    private static final Pattern DOUBLE = Pattern.compile("\\d*\\.\\d*[dD]?");
    private static final Pattern FLOAT = Pattern.compile("\\d*\\.\\d*[fF]?");
    private static final int DEFAULT_INFER_LINES = 25;
    private static final Set<String> NO_REQUIRED_FIELDS = ImmutableSet.of();
    private static final Pattern AVRO_COMPATIBLE = Pattern.compile("^[A-Za-z_][A-Za-z\\d_]*$");
    private static final CharMatcher NON_PRINTABLE = CharMatcher.inRange((char)' ', (char)'~').negate();

    static CSVReader newReader(InputStream incoming, CSVProperties props) {
        return new CSVReader(new InputStreamReader(incoming, Charset.forName(props.charset)), props.delimiter.charAt(0), props.quote.charAt(0), props.escape.charAt(0), props.linesToSkip, false, true);
    }

    static CSVParser newParser(CSVProperties props) {
        return new CSVParser(props.delimiter.charAt(0), props.quote.charAt(0), props.escape.charAt(0), false, true);
    }

    public static Schema inferNullableSchema(String name, InputStream incoming, CSVProperties props) throws IOException {
        return AvroCSV.inferSchemaInternal(name, incoming, props, NO_REQUIRED_FIELDS, true);
    }

    public static Schema inferNullableSchema(String name, InputStream incoming, CSVProperties props, Set<String> requiredFields) throws IOException {
        return AvroCSV.inferSchemaInternal(name, incoming, props, requiredFields, true);
    }

    public static Schema inferSchema(String name, InputStream incoming, CSVProperties props) throws IOException {
        return AvroCSV.inferSchemaInternal(name, incoming, props, NO_REQUIRED_FIELDS, false);
    }

    public static Schema inferSchema(String name, InputStream incoming, CSVProperties props, Set<String> requiredFields) throws IOException {
        return AvroCSV.inferSchemaInternal(name, incoming, props, requiredFields, false);
    }

    private static Schema inferSchemaInternal(String name, InputStream incoming, CSVProperties props, Set<String> requiredFields, boolean makeNullable) throws IOException {
        int i;
        String[] line;
        String[] header;
        CSVReader reader = AvroCSV.newReader(incoming, props);
        if (props.useHeader) {
            header = reader.readNext();
            line = reader.readNext();
            Objects.requireNonNull(line, "No content to infer schema");
        } else if (props.header != null) {
            header = AvroCSV.newParser(props).parseLine(props.header);
            line = reader.readNext();
            Objects.requireNonNull(line, "No content to infer schema");
        } else {
            line = reader.readNext();
            Objects.requireNonNull(line, "No content to infer schema");
            header = new String[line.length];
            for (int i2 = 0; i2 < line.length; ++i2) {
                header[i2] = "field_" + i2;
            }
        }
        Schema.Type[] types = new Schema.Type[header.length];
        String[] values = new String[header.length];
        boolean[] nullable = new boolean[header.length];
        boolean[] empty = new boolean[header.length];
        for (int processed = 0; processed < 25 && line != null; ++processed) {
            for (i = 0; i < header.length; ++i) {
                if (i < line.length) {
                    if (types[i] == null) {
                        types[i] = AvroCSV.inferFieldType(line[i]);
                        if (types[i] != null) {
                            values[i] = line[i];
                        }
                    }
                    if (line[i] == null) {
                        nullable[i] = true;
                        continue;
                    }
                    if (!line[i].isEmpty()) continue;
                    empty[i] = true;
                    continue;
                }
                nullable[i] = true;
            }
            line = reader.readNext();
        }
        SchemaBuilder.FieldAssembler<Schema> fieldAssembler = SchemaBuilder.record(name).fields();
        for (i = 0; i < header.length; ++i) {
            boolean foundNull;
            if (header[i] == null) {
                throw new RuntimeException("Bad header for field " + i + ": null");
            }
            String fieldName = header[i].trim();
            if (fieldName.isEmpty()) {
                throw new RuntimeException("Bad header for field " + i + ": \"" + fieldName + "\"");
            }
            if (!AvroCSV.isAvroCompatibleName(fieldName)) {
                throw new RuntimeException("Bad header for field, should start with a character or _ and can contain only alphanumerics and _ " + i + ": \"" + fieldName + "\"");
            }
            boolean bl = foundNull = nullable[i] || empty[i] && types[i] != Schema.Type.STRING;
            if (requiredFields.contains(fieldName)) {
                if (foundNull) {
                    throw new RuntimeException("Found null value for required field: " + fieldName + " (" + (Object)((Object)types[i]) + ")");
                }
                fieldAssembler = ((SchemaBuilder.FieldBuilder)fieldAssembler.name(fieldName).doc("Type inferred from '" + AvroCSV.sample(values[i]) + "'")).type(AvroCSV.schema(types[i], false)).noDefault();
                continue;
            }
            SchemaBuilder.GenericDefault defaultBuilder = ((SchemaBuilder.FieldBuilder)fieldAssembler.name(fieldName).doc("Type inferred from '" + AvroCSV.sample(values[i]) + "'")).type(AvroCSV.schema(types[i], makeNullable || foundNull));
            fieldAssembler = makeNullable || foundNull ? defaultBuilder.withDefault(null) : defaultBuilder.noDefault();
        }
        return fieldAssembler.endRecord();
    }

    private static String sample(String value) {
        if (value != null) {
            return NON_PRINTABLE.replaceFrom(value.subSequence(0, Math.min(50, value.length())), '.');
        }
        return "null";
    }

    private static Schema schema(Schema.Type type, boolean makeNullable) {
        Schema schema = Schema.create(type == null ? Schema.Type.STRING : type);
        if (makeNullable || type == null) {
            schema = Schema.createUnion(Lists.newArrayList((Object[])new Schema[]{Schema.create(Schema.Type.NULL), schema}));
        }
        return schema;
    }

    private static Schema.Type inferFieldType(String example) {
        if (example == null || example.isEmpty()) {
            return null;
        }
        if (LONG.matcher(example).matches()) {
            return Schema.Type.LONG;
        }
        if (DOUBLE.matcher(example).matches()) {
            return Schema.Type.DOUBLE;
        }
        if (FLOAT.matcher(example).matches()) {
            return Schema.Type.FLOAT;
        }
        return Schema.Type.STRING;
    }

    private static boolean isAvroCompatibleName(String name) {
        return AVRO_COMPATIBLE.matcher(name).matches();
    }
}

