/*
 * Decompiled with CFR 0.152.
 */
package org.apache.parquet.cli.commands;

import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import org.apache.hadoop.conf.Configuration;
import org.apache.parquet.cli.commands.ParquetFileTest;
import org.apache.parquet.cli.commands.ScanCommand;
import org.junit.Assert;
import org.junit.Test;

public class ScanCommandTest
extends ParquetFileTest {
    @Test
    public void testScanCommand() throws IOException {
        File file = this.parquetFile();
        ScanCommand command = new ScanCommand(ScanCommandTest.createLogger());
        command.sourceFiles = Arrays.asList(file.getAbsolutePath());
        command.setConf(new Configuration());
        Assert.assertEquals((long)0L, (long)command.run());
    }

    @Test
    public void testScanCommandWithMultipleSourceFiles() throws IOException {
        File file = this.parquetFile();
        ScanCommand command = new ScanCommand(ScanCommandTest.createLogger());
        command.sourceFiles = Arrays.asList(file.getAbsolutePath(), file.getAbsolutePath());
        command.setConf(new Configuration());
        Assert.assertEquals((long)0L, (long)command.run());
    }

    @Test(expected=IllegalArgumentException.class)
    public void testScanCommandWithInvalidColumnName() throws IOException {
        File file = this.parquetFile();
        ScanCommand command = new ScanCommand(ScanCommandTest.createLogger());
        command.sourceFiles = Arrays.asList(file.getAbsolutePath());
        command.columns = Arrays.asList("invalid_field");
        command.setConf(new Configuration());
        command.run();
    }
}

