/*
 * Decompiled with CFR 0.152.
 */
package org.apache.parquet.cli;

import java.io.IOException;
import java.net.URI;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.parquet.cli.BaseCommand;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Before;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BaseCommandTest {
    private static final String FILE_PATH = "/var/tmp/test.parquet";
    private static final String WIN_FILE_PATH = "C:\\Test\\Downloads\\test.parquet";
    private Logger console = LoggerFactory.getLogger(BaseCommandTest.class);
    private TestCommand command;

    @Before
    public void setUp() {
        this.command = new TestCommand(this.console);
    }

    @Test
    public void qualifiedPathTest() throws IOException {
        Path path = this.command.qualifiedPath(FILE_PATH);
        Assert.assertEquals((Object)"test.parquet", (Object)path.getName());
    }

    @Test
    public void qualifiedURITest() throws IOException {
        URI uri = this.command.qualifiedURI(FILE_PATH);
        Assert.assertEquals((Object)FILE_PATH, (Object)uri.getPath());
    }

    @Test
    public void qualifiedURIResourceURITest() throws IOException {
        URI uri = this.command.qualifiedURI("resource:/a");
        Assert.assertEquals((Object)"/a", (Object)uri.getPath());
    }

    @Test
    public void qualifiedPathTestForWindows() throws IOException {
        Assume.assumeTrue((boolean)System.getProperty("os.name").toLowerCase().startsWith("win"));
        Path path = this.command.qualifiedPath(WIN_FILE_PATH);
        Assert.assertEquals((Object)"test.parquet", (Object)path.getName());
    }

    @Test
    public void qualifiedURITestForWindows() throws IOException {
        Assume.assumeTrue((boolean)System.getProperty("os.name").toLowerCase().startsWith("win"));
        URI uri = this.command.qualifiedURI(WIN_FILE_PATH);
        Assert.assertEquals((Object)"/C:/Test/Downloads/test.parquet", (Object)uri.getPath());
    }

    class TestCommand
    extends BaseCommand {
        public TestCommand(Logger console) {
            super(console);
            this.setConf(new Configuration());
        }

        public int run() throws IOException {
            return 0;
        }

        public List<String> getExamples() {
            return null;
        }
    }
}

