/*
 * Decompiled with CFR 0.152.
 */
package org.apache.parquet.cli.csv;

import au.com.bytecode.opencsv.CSVReader;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.apache.parquet.cli.csv.AvroCSV;
import org.apache.parquet.cli.csv.CSVProperties;
import org.apache.parquet.cli.csv.RecordBuilder;
import org.apache.parquet.cli.util.RuntimeIOException;
import shaded.parquet.org.apache.avro.Schema;

public class AvroCSVReader<E>
implements Iterator<E>,
Iterable<E>,
Closeable {
    private final boolean reuseRecords;
    private final CSVReader reader;
    private final RecordBuilder<E> builder;
    private boolean hasNext = false;
    private String[] next = null;
    private E record = null;

    public AvroCSVReader(InputStream stream, CSVProperties props, Schema schema, Class<E> type, boolean reuseRecords) {
        this.reader = AvroCSV.newReader(stream, props);
        this.reuseRecords = reuseRecords;
        Preconditions.checkArgument((boolean)Schema.Type.RECORD.equals((Object)schema.getType()), (Object)"Schemas for CSV files must be records of primitive types");
        ArrayList header = null;
        if (props.useHeader) {
            this.hasNext = this.advance();
            header = Lists.newArrayList((Object[])this.next);
        } else if (props.header != null) {
            try {
                header = Lists.newArrayList((Object[])AvroCSV.newParser(props).parseLine(props.header));
            }
            catch (IOException e) {
                throw new RuntimeIOException("Failed to parse header from properties: " + props.header, e);
            }
        }
        this.builder = new RecordBuilder<E>(schema, type, header);
        this.hasNext = this.advance();
    }

    @Override
    public boolean hasNext() {
        return this.hasNext;
    }

    @Override
    public E next() {
        if (!this.hasNext) {
            throw new NoSuchElementException();
        }
        try {
            if (this.reuseRecords) {
                E e = this.record = this.builder.makeRecord(this.next, this.record);
                return e;
            }
            E e = this.builder.makeRecord(this.next, null);
            return e;
        }
        finally {
            this.hasNext = this.advance();
        }
    }

    private boolean advance() {
        try {
            this.next = this.reader.readNext();
        }
        catch (IOException ex) {
            throw new RuntimeIOException("Could not read record", ex);
        }
        return this.next != null;
    }

    @Override
    public void close() {
        try {
            this.reader.close();
        }
        catch (IOException e) {
            throw new RuntimeIOException("Cannot close reader", e);
        }
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("Remove is not implemented.");
    }

    @Override
    public Iterator<E> iterator() {
        return this;
    }
}

