/*
 * Decompiled with CFR 0.152.
 */
package org.apache.parquet.cli.commands;

import com.beust.jcommander.Parameter;
import com.beust.jcommander.Parameters;
import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.PropertyAccessor;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.List;
import org.apache.parquet.bytes.ByteBufferInputStream;
import org.apache.parquet.bytes.BytesUtils;
import org.apache.parquet.cli.BaseCommand;
import org.apache.parquet.format.CliUtils;
import org.apache.parquet.format.Util;
import org.apache.parquet.hadoop.ParquetFileReader;
import org.apache.parquet.hadoop.ParquetFileWriter;
import org.apache.parquet.hadoop.metadata.ParquetMetadata;
import org.apache.parquet.hadoop.util.HadoopInputFile;
import org.apache.parquet.io.InputFile;
import org.apache.parquet.io.SeekableInputStream;
import org.slf4j.Logger;

@Parameters(commandDescription="Print the Parquet file footer in json format")
public class ShowFooterCommand
extends BaseCommand {
    @Parameter(description="<parquet path>", required=true)
    String target;
    @Parameter(names={"-r", "--raw"}, description="Print the raw thrift object of the footer")
    boolean raw = false;

    public ShowFooterCommand(Logger console) {
        super(console);
    }

    @Override
    public int run() throws IOException {
        HadoopInputFile inputFile = HadoopInputFile.fromPath(this.qualifiedPath(this.target), this.getConf());
        this.console.info(this.raw ? this.readRawFooter(inputFile) : this.readFooter(inputFile));
        return 0;
    }

    private String readFooter(InputFile inputFile) throws JsonProcessingException, IOException {
        String json;
        try (ParquetFileReader reader = ParquetFileReader.open(inputFile);){
            ParquetMetadata footer = reader.getFooter();
            ObjectMapper mapper = this.createObjectMapper();
            mapper.setVisibility(PropertyAccessor.ALL, JsonAutoDetect.Visibility.NONE);
            mapper.setVisibility(PropertyAccessor.FIELD, JsonAutoDetect.Visibility.ANY);
            json = mapper.writerWithDefaultPrettyPrinter().writeValueAsString(footer);
        }
        return json;
    }

    private ObjectMapper createObjectMapper() {
        ObjectMapper mapper = new ObjectMapper();
        mapper.configure(SerializationFeature.FAIL_ON_EMPTY_BEANS, false);
        mapper.configure(SerializationFeature.ORDER_MAP_ENTRIES_BY_KEYS, true);
        mapper.registerModule(new JavaTimeModule());
        return mapper;
    }

    private String readRawFooter(InputFile file) throws IOException {
        int FOOTER_LENGTH_SIZE;
        long fileLen = file.getLength();
        if (fileLen < (long)(ParquetFileWriter.MAGIC.length + (FOOTER_LENGTH_SIZE = 4) + ParquetFileWriter.MAGIC.length)) {
            throw new RuntimeException("Not a Parquet file (length is too low: " + fileLen + ")");
        }
        try (SeekableInputStream f = file.newStream();){
            byte[] magic = new byte[ParquetFileWriter.MAGIC.length];
            long fileMetadataLengthIndex = fileLen - (long)magic.length - (long)FOOTER_LENGTH_SIZE;
            f.seek(fileMetadataLengthIndex);
            int fileMetadataLength = BytesUtils.readIntLittleEndian(f);
            f.readFully(magic);
            if (Arrays.equals(ParquetFileWriter.EFMAGIC, magic)) {
                throw new RuntimeException("Parquet files with encrypted footers are not supported.");
            }
            if (!Arrays.equals(ParquetFileWriter.MAGIC, magic)) {
                throw new RuntimeException("Not a Parquet file (expected magic number at tail, but found " + Arrays.toString(magic) + ')');
            }
            long fileMetadataIndex = fileMetadataLengthIndex - (long)fileMetadataLength;
            if (fileMetadataIndex < (long)magic.length || fileMetadataIndex >= fileMetadataLengthIndex) {
                throw new RuntimeException("Corrupted file: the footer index is not within the file: " + fileMetadataIndex);
            }
            f.seek(fileMetadataIndex);
            ByteBuffer footerBytesBuffer = ByteBuffer.allocate(fileMetadataLength);
            f.readFully(footerBytesBuffer);
            footerBytesBuffer.flip();
            ByteBufferInputStream footerBytesStream = ByteBufferInputStream.wrap(footerBytesBuffer);
            String string = this.prettify(CliUtils.toJson(Util.readFileMetaData(footerBytesStream)));
            return string;
        }
    }

    private String prettify(String json) throws JsonProcessingException {
        ObjectMapper mapper = this.createObjectMapper();
        Object obj = mapper.readValue(json, Object.class);
        return mapper.writerWithDefaultPrettyPrinter().writeValueAsString(obj);
    }

    @Override
    public List<String> getExamples() {
        return Arrays.asList("# Print the parquet-mr interpreted footer of the specified Parquet file in json format", "sample.parquet", "# Print the raw thrift footer object of the specified Parquet file in json format", "sample.parquet --raw");
    }
}

