/*
 * Decompiled with CFR 0.152.
 */
package org.apache.parquet.cli.commands;

import com.beust.jcommander.Parameter;
import com.beust.jcommander.Parameters;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.parquet.cli.BaseCommand;
import org.apache.parquet.format.converter.ParquetMetadataConverter;
import org.apache.parquet.hadoop.ParquetFileReader;
import org.apache.parquet.hadoop.metadata.BlockMetaData;
import org.apache.parquet.hadoop.metadata.ColumnChunkMetaData;
import org.apache.parquet.hadoop.metadata.ParquetMetadata;
import org.slf4j.Logger;

@Parameters(commandDescription="Print the column sizes of a parquet file")
public class ColumnSizeCommand
extends BaseCommand {
    @Parameter(description="<parquet path>")
    String target;
    @Parameter(names={"-c", "--column", "--columns"}, description="List of columns in the case sensitive dot format to be calculated, for example a.b.c. If an input column is intermediate column, all the child columns will be printed out. If no columns are set, all the columns will be printed out.", required=false)
    List<String> columns;

    public ColumnSizeCommand(Logger console) {
        super(console);
    }

    @Override
    public int run() throws IOException {
        Preconditions.checkArgument((this.target != null ? 1 : 0) != 0, (Object)"A Parquet file is required.");
        Path inputFile = new Path(this.target);
        Map<String, Long> columnSizes = this.getColumnSizeInBytes(inputFile);
        Map<String, Float> columnRatio = this.getColumnRatio(columnSizes);
        if (this.columns != null && this.columns.size() > 0) {
            for (String inputColumn : this.columns) {
                long size = 0L;
                float ratio = 0.0f;
                for (String column : columnSizes.keySet()) {
                    if (!column.equals(inputColumn) && !column.startsWith(inputColumn + ".")) continue;
                    size += columnSizes.get(column).longValue();
                    ratio += columnRatio.get(column).floatValue();
                }
                this.console.info(inputColumn + "-> Size In Bytes: " + size + " Size In Ratio: " + ratio);
            }
        } else {
            for (String column : columnSizes.keySet()) {
                this.console.info(column + "-> Size In Bytes: " + columnSizes.get(column) + " Size In Ratio: " + columnRatio.get(column));
            }
        }
        return 0;
    }

    @Override
    public List<String> getExamples() {
        return Lists.newArrayList((Object[])new String[]{"# Print every column size in byte and ratio for a Parquet file", "sample.parquet", "sample.parquet -c col_1", "sample.parquet --column col_2", "sample.parquet --columns col_1 col_2", "sample.parquet --columns col_1 col_2.sub_col_a"});
    }

    public Map<String, Long> getColumnSizeInBytes(Path inputFile) throws IOException {
        HashMap<String, Long> colSizes = new HashMap<String, Long>();
        ParquetMetadata pmd = ParquetFileReader.readFooter(new Configuration(), inputFile, ParquetMetadataConverter.NO_FILTER);
        for (BlockMetaData block : pmd.getBlocks()) {
            for (ColumnChunkMetaData column : block.getColumns()) {
                String colName = column.getPath().toDotString();
                colSizes.put(colName, column.getTotalSize() + colSizes.getOrDefault(colName, 0L));
            }
        }
        return colSizes;
    }

    public Map<String, Float> getColumnRatio(Map<String, Long> colSizes) {
        long totalSize = colSizes.values().stream().reduce(0L, Long::sum);
        HashMap<String, Float> colRatio = new HashMap<String, Float>();
        for (Map.Entry<String, Long> entry : colSizes.entrySet()) {
            colRatio.put(entry.getKey(), Float.valueOf((float)entry.getValue().longValue() / (float)totalSize));
        }
        return colRatio;
    }
}

