/*
 * Decompiled with CFR 0.152.
 */
package org.apache.parquet.cli.commands;

import com.beust.jcommander.Parameter;
import com.beust.jcommander.Parameters;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.List;
import org.apache.hadoop.fs.Path;
import org.apache.parquet.HadoopReadOptions;
import org.apache.parquet.cli.BaseCommand;
import org.apache.parquet.format.converter.ParquetMetadataConverter;
import org.apache.parquet.hadoop.ParquetFileReader;
import org.apache.parquet.hadoop.ParquetFileWriter;
import org.apache.parquet.hadoop.metadata.ParquetMetadata;
import org.apache.parquet.hadoop.util.ColumnMasker;
import org.apache.parquet.hadoop.util.CompressionConverter;
import org.apache.parquet.hadoop.util.HadoopInputFile;
import org.apache.parquet.schema.MessageType;
import org.slf4j.Logger;

@Parameters(commandDescription="(Deprecated: will be removed in 2.0.0, use rewrite command instead) Replace columns with masked values and write to a new Parquet file")
public class ColumnMaskingCommand
extends BaseCommand {
    private ColumnMasker masker = new ColumnMasker();
    @Parameter(names={"-m", "--mode"}, description="<mask mode: nullify>", required=true)
    String mode;
    @Parameter(names={"-i", "--input"}, description="<input parquet file path>", required=true)
    String input;
    @Parameter(names={"-o", "--output"}, description="<output parquet file path>", required=true)
    String output;
    @Parameter(names={"-c", "--columns"}, description="<columns to be replaced with masked value>", required=true)
    List<String> cols;

    public ColumnMaskingCommand(Logger console) {
        super(console);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int run() throws IOException {
        Preconditions.checkArgument((this.mode != null && this.mode.equals("nullify") ? 1 : 0) != 0, (Object)"mask mode cannot be null and can be only nullify");
        Preconditions.checkArgument((this.input != null && this.output != null ? 1 : 0) != 0, (Object)"Both input and output parquet file paths are required.");
        Preconditions.checkArgument((this.cols != null && this.cols.size() > 0 ? 1 : 0) != 0, (Object)"columns cannot be null or empty");
        ColumnMasker.MaskMode maskMode = ColumnMasker.MaskMode.fromString(this.mode);
        Path inPath = new Path(this.input);
        Path outPath = new Path(this.output);
        ParquetMetadata metaData = ParquetFileReader.readFooter(this.getConf(), inPath, ParquetMetadataConverter.NO_FILTER);
        MessageType schema = metaData.getFileMetaData().getSchema();
        ParquetFileWriter writer = new ParquetFileWriter(this.getConf(), schema, outPath, ParquetFileWriter.Mode.CREATE);
        writer.start();
        try (CompressionConverter.TransParquetFileReader reader = new CompressionConverter.TransParquetFileReader(HadoopInputFile.fromPath(inPath, this.getConf()), HadoopReadOptions.builder(this.getConf()).build());){
            this.masker.processBlocks(reader, writer, metaData, schema, this.cols, maskMode);
        }
        finally {
            writer.end(metaData.getFileMetaData().getKeyValueMetaData());
        }
        return 0;
    }

    @Override
    public List<String> getExamples() {
        return Lists.newArrayList((Object[])new String[]{"# Replace columns with masked values and write to a new Parquet file", "-m nullify -i input.parquet -o output.parquet -c col1_name"});
    }
}

