/*
 * Decompiled with CFR 0.152.
 */
package org.apache.parquet.cli.commands;

import com.beust.jcommander.Parameter;
import com.beust.jcommander.Parameters;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.List;
import org.apache.hadoop.fs.Path;
import org.apache.parquet.HadoopReadOptions;
import org.apache.parquet.cli.BaseCommand;
import org.apache.parquet.format.converter.ParquetMetadataConverter;
import org.apache.parquet.hadoop.ParquetFileReader;
import org.apache.parquet.hadoop.ParquetFileWriter;
import org.apache.parquet.hadoop.metadata.CompressionCodecName;
import org.apache.parquet.hadoop.metadata.ParquetMetadata;
import org.apache.parquet.hadoop.util.CompressionConverter;
import org.apache.parquet.hadoop.util.HadoopInputFile;
import org.apache.parquet.schema.MessageType;
import org.slf4j.Logger;

@Parameters(commandDescription="Translate the compression from one to another (It doesn't support bloom filter feature yet).")
public class TransCompressionCommand
extends BaseCommand {
    private CompressionConverter compressionConverter = new CompressionConverter();
    @Parameter(description="<input parquet file path>")
    String input;
    @Parameter(names={"-o", "--output"}, description="<output parquet file path>")
    String output;
    @Parameter(names={"-c", "--compression-codec"}, description="<new compression codec")
    String codec;

    public TransCompressionCommand(Logger console) {
        super(console);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int run() throws IOException {
        Preconditions.checkArgument((this.input != null && this.output != null ? 1 : 0) != 0, (Object)"Both input and output parquet file paths are required.");
        Preconditions.checkArgument((this.codec != null ? 1 : 0) != 0, (Object)"The codec cannot be null");
        Path inPath = new Path(this.input);
        Path outPath = new Path(this.output);
        CompressionCodecName codecName = CompressionCodecName.valueOf(this.codec);
        ParquetMetadata metaData = ParquetFileReader.readFooter(this.getConf(), inPath, ParquetMetadataConverter.NO_FILTER);
        MessageType schema = metaData.getFileMetaData().getSchema();
        ParquetFileWriter writer = new ParquetFileWriter(this.getConf(), schema, outPath, ParquetFileWriter.Mode.CREATE);
        writer.start();
        try (CompressionConverter.TransParquetFileReader reader = new CompressionConverter.TransParquetFileReader(HadoopInputFile.fromPath(inPath, this.getConf()), HadoopReadOptions.builder(this.getConf()).build());){
            this.compressionConverter.processBlocks(reader, writer, metaData, schema, metaData.getFileMetaData().getCreatedBy(), codecName);
        }
        finally {
            writer.end(metaData.getFileMetaData().getKeyValueMetaData());
        }
        return 0;
    }

    @Override
    public List<String> getExamples() {
        return Lists.newArrayList((Object[])new String[]{"# Translate the compression from one to another", " input.parquet -o output.parquet -c ZSTD"});
    }
}

