/*
 * Decompiled with CFR 0.152.
 */
package org.apache.parquet.cli.commands;

import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import org.apache.commons.io.FileUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileAlreadyExistsException;
import org.apache.parquet.cli.commands.ParquetFileTest;
import org.apache.parquet.cli.commands.SchemaCommand;
import org.junit.Assert;
import org.junit.Test;

public class SchemaCommandTest
extends ParquetFileTest {
    @Test
    public void testSchemaCommand() throws IOException {
        File file = this.parquetFile();
        SchemaCommand command = new SchemaCommand(SchemaCommandTest.createLogger());
        command.targets = Arrays.asList(file.getAbsolutePath());
        command.setConf(new Configuration());
        Assert.assertEquals((long)0L, (long)command.run());
    }

    @Test
    public void testSchemaCommandOverwriteExistentFile() throws IOException {
        File inputFile = this.parquetFile();
        File outputFile = new File(this.getTempFolder(), this.getClass().getSimpleName() + ".avsc");
        FileUtils.touch((File)outputFile);
        Assert.assertEquals((long)0L, (long)outputFile.length());
        SchemaCommand command = new SchemaCommand(SchemaCommandTest.createLogger());
        command.targets = Arrays.asList(inputFile.getAbsolutePath());
        command.outputPath = outputFile.getAbsolutePath();
        command.overwrite = true;
        command.setConf(new Configuration());
        Assert.assertEquals((long)0L, (long)command.run());
        Assert.assertTrue((0L < outputFile.length() ? 1 : 0) != 0);
    }

    @Test(expected=FileAlreadyExistsException.class)
    public void testSchemaCommandOverwriteExistentFileWithoutOverwriteOption() throws IOException {
        File inputFile = this.parquetFile();
        File outputFile = new File(this.getTempFolder(), this.getClass().getSimpleName() + ".avsc");
        FileUtils.touch((File)outputFile);
        SchemaCommand command = new SchemaCommand(SchemaCommandTest.createLogger());
        command.targets = Arrays.asList(inputFile.getAbsolutePath());
        command.outputPath = outputFile.getAbsolutePath();
        command.setConf(new Configuration());
        command.run();
    }
}

