/*
 * Decompiled with CFR 0.152.
 */
package org.apache.parquet.cli.commands;

import java.io.File;
import java.io.IOException;
import java.util.Map;
import java.util.Random;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.parquet.cli.commands.ColumnSizeCommand;
import org.apache.parquet.cli.commands.ParquetFileTest;
import org.apache.parquet.example.data.simple.SimpleGroup;
import org.apache.parquet.hadoop.ParquetWriter;
import org.apache.parquet.hadoop.example.ExampleParquetWriter;
import org.apache.parquet.schema.GroupType;
import org.apache.parquet.schema.MessageType;
import org.apache.parquet.schema.PrimitiveType;
import org.apache.parquet.schema.Type;
import org.junit.Assert;
import org.junit.Test;

public class ColumnSizeCommandTest
extends ParquetFileTest {
    private final int numRecord = 10000;
    private ColumnSizeCommand command = new ColumnSizeCommand(ColumnSizeCommandTest.createLogger());
    private Configuration conf = new Configuration();

    @Test
    public void testColumnSizeCommand() throws IOException {
        File file = this.parquetFile();
        ColumnSizeCommand command = new ColumnSizeCommand(ColumnSizeCommandTest.createLogger());
        command.target = file.getAbsolutePath();
        command.setConf(new Configuration());
        Assert.assertEquals((long)0L, (long)command.run());
    }

    @Test
    public void testColumnSize() throws Exception {
        String inputFile = this.createParquetFile();
        Map columnSizeInBytes = this.command.getColumnSizeInBytes(new Path(inputFile));
        Assert.assertEquals((long)columnSizeInBytes.size(), (long)2L);
        Assert.assertTrue(((Long)columnSizeInBytes.get("DocId") > (Long)columnSizeInBytes.get("Num") ? 1 : 0) != 0);
        Map columnRatio = this.command.getColumnRatio(columnSizeInBytes);
        Assert.assertTrue((((Float)columnRatio.get("DocId")).floatValue() > ((Float)columnRatio.get("Num")).floatValue() ? 1 : 0) != 0);
    }

    private String createParquetFile() throws IOException {
        MessageType schema = new MessageType("schema", new Type[]{new PrimitiveType(Type.Repetition.REQUIRED, PrimitiveType.PrimitiveTypeName.INT64, "DocId"), new PrimitiveType(Type.Repetition.REQUIRED, PrimitiveType.PrimitiveTypeName.INT32, "Num")});
        this.conf.set("parquet.example.schema", schema.toString());
        String file = this.randomParquetFile().getAbsolutePath();
        ExampleParquetWriter.Builder builder = (ExampleParquetWriter.Builder)ExampleParquetWriter.builder((Path)new Path(file)).withConf(this.conf);
        Random rnd = new Random();
        try (ParquetWriter writer = builder.build();){
            for (int i = 0; i < 10000; ++i) {
                SimpleGroup g = new SimpleGroup((GroupType)schema);
                g.add("DocId", rnd.nextLong());
                g.add("Num", rnd.nextInt());
                writer.write((Object)g);
            }
        }
        return file;
    }
}

