/*
 * Decompiled with CFR 0.152.
 */
package org.apache.parquet.cli.commands;

import com.beust.jcommander.Parameter;
import com.beust.jcommander.Parameters;
import com.beust.jcommander.internal.Lists;
import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import javax.annotation.Nullable;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.parquet.CorruptStatistics;
import org.apache.parquet.VersionParser;
import org.apache.parquet.bytes.BytesInput;
import org.apache.parquet.cli.BaseCommand;
import org.apache.parquet.column.ColumnDescriptor;
import org.apache.parquet.column.ColumnReader;
import org.apache.parquet.column.page.DataPage;
import org.apache.parquet.column.page.DataPageV1;
import org.apache.parquet.column.page.DataPageV2;
import org.apache.parquet.column.page.DictionaryPage;
import org.apache.parquet.column.page.PageReadStore;
import org.apache.parquet.column.page.PageReader;
import org.apache.parquet.column.statistics.Statistics;
import org.apache.parquet.format.converter.ParquetMetadataConverter;
import org.apache.parquet.hadoop.ParquetFileReader;
import org.apache.parquet.hadoop.metadata.FileMetaData;
import org.apache.parquet.hadoop.metadata.ParquetMetadata;
import org.apache.parquet.io.ParquetDecodingException;
import org.apache.parquet.io.api.Binary;
import org.apache.parquet.io.api.PrimitiveConverter;
import org.apache.parquet.schema.PrimitiveType;
import org.apache.parquet.util.DynConstructors;
import org.slf4j.Logger;

@Parameters(commandDescription="Check Parquet files for corrupt page and column stats (PARQUET-251)")
public class CheckParquet251Command
extends BaseCommand {
    @Parameter(description="<files>", required=true)
    List<String> files;
    private static final DynConstructors.Ctor<ColumnReader> COL_READER_CTOR = new DynConstructors.Builder(ColumnReader.class).hiddenImpl("org.apache.parquet.column.impl.ColumnReaderImpl", new Class[]{ColumnDescriptor.class, PageReader.class, PrimitiveConverter.class, VersionParser.ParsedVersion.class}).build();

    public CheckParquet251Command(Logger console) {
        super(console);
    }

    @Override
    public int run() throws IOException {
        boolean badFiles = false;
        for (String file : this.files) {
            String problem = this.check(file);
            if (problem != null) {
                badFiles = true;
                this.console.info("{} has corrupt stats: {}", (Object)file, (Object)problem);
                continue;
            }
            this.console.info("{} has no corrupt stats", (Object)file);
        }
        return badFiles ? 1 : 0;
    }

    private String check(String file) throws IOException {
        Path path = this.qualifiedPath(file);
        ParquetMetadata footer = ParquetFileReader.readFooter((Configuration)this.getConf(), (Path)path, (ParquetMetadataConverter.MetadataFilter)ParquetMetadataConverter.NO_FILTER);
        FileMetaData meta = footer.getFileMetaData();
        String createdBy = meta.getCreatedBy();
        if (CorruptStatistics.shouldIgnoreStatistics((String)createdBy, (PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.BINARY)) {
            FileMetaData fakeMeta = new FileMetaData(meta.getSchema(), meta.getKeyValueMetaData(), "parquet-mr version 1.11.0 (build 18519eb8e059865652eee3ff0e8593f126701da4)");
            List columns = Lists.newArrayList();
            Iterables.addAll((Collection)columns, (Iterable)Iterables.filter((Iterable)meta.getSchema().getColumns(), (Predicate)new Predicate<ColumnDescriptor>(){

                public boolean apply(@Nullable ColumnDescriptor input) {
                    return input != null && input.getType() == PrimitiveType.PrimitiveTypeName.BINARY;
                }
            }));
            ParquetFileReader reader = new ParquetFileReader(this.getConf(), fakeMeta, path, footer.getBlocks(), columns);
            try {
                PageStatsValidator validator = new PageStatsValidator();
                PageReadStore pages = reader.readNextRowGroup();
                while (pages != null) {
                    validator.validate(columns, pages);
                    pages = reader.readNextRowGroup();
                }
            }
            catch (BadStatsException e) {
                return e.getMessage();
            }
        }
        return null;
    }

    @Override
    public List<String> getExamples() {
        return Arrays.asList("# Check file1.parquet for corrupt page and column stats", "file1.parquet");
    }

    private static <T extends Comparable<T>> Statistics<T> getStatisticsFromPageHeader(DataPage page) {
        return (Statistics)page.accept(new DataPage.Visitor<Statistics<T>>(){

            public Statistics<T> visit(DataPageV1 dataPageV1) {
                return dataPageV1.getStatistics();
            }

            public Statistics<T> visit(DataPageV2 dataPageV2) {
                return dataPageV2.getStatistics();
            }
        });
    }

    private PrimitiveConverter getValidatingConverter(final DataPage page, PrimitiveType.PrimitiveTypeName type) {
        return (PrimitiveConverter)type.convert((PrimitiveType.PrimitiveTypeNameConverter)new PrimitiveType.PrimitiveTypeNameConverter<PrimitiveConverter, RuntimeException>(){

            public PrimitiveConverter convertFLOAT(PrimitiveType.PrimitiveTypeName primitiveTypeName) {
                final StatsValidator validator = new StatsValidator(page);
                return new PrimitiveConverter(){

                    public void addFloat(float value) {
                        validator.validate(Float.valueOf(value));
                    }
                };
            }

            public PrimitiveConverter convertDOUBLE(PrimitiveType.PrimitiveTypeName primitiveTypeName) {
                final StatsValidator validator = new StatsValidator(page);
                return new PrimitiveConverter(){

                    public void addDouble(double value) {
                        validator.validate(value);
                    }
                };
            }

            public PrimitiveConverter convertINT32(PrimitiveType.PrimitiveTypeName primitiveTypeName) {
                final StatsValidator validator = new StatsValidator(page);
                return new PrimitiveConverter(){

                    public void addInt(int value) {
                        validator.validate(value);
                    }
                };
            }

            public PrimitiveConverter convertINT64(PrimitiveType.PrimitiveTypeName primitiveTypeName) {
                final StatsValidator validator = new StatsValidator(page);
                return new PrimitiveConverter(){

                    public void addLong(long value) {
                        validator.validate(value);
                    }
                };
            }

            public PrimitiveConverter convertBOOLEAN(PrimitiveType.PrimitiveTypeName primitiveTypeName) {
                final StatsValidator validator = new StatsValidator(page);
                return new PrimitiveConverter(){

                    public void addBoolean(boolean value) {
                        validator.validate(value);
                    }
                };
            }

            public PrimitiveConverter convertINT96(PrimitiveType.PrimitiveTypeName primitiveTypeName) {
                return this.convertBINARY(primitiveTypeName);
            }

            public PrimitiveConverter convertFIXED_LEN_BYTE_ARRAY(PrimitiveType.PrimitiveTypeName primitiveTypeName) {
                return this.convertBINARY(primitiveTypeName);
            }

            public PrimitiveConverter convertBINARY(PrimitiveType.PrimitiveTypeName primitiveTypeName) {
                final StatsValidator validator = new StatsValidator(page);
                return new PrimitiveConverter(){

                    public void addBinary(Binary value) {
                        validator.validate(value);
                    }
                };
            }
        });
    }

    public class PageStatsValidator {
        public void validate(List<ColumnDescriptor> columns, PageReadStore store) {
            for (ColumnDescriptor desc : columns) {
                DataPage page;
                PageReader reader = store.getPageReader(desc);
                DictionaryPage dict = reader.readDictionaryPage();
                DictionaryPage reusableDict = null;
                if (dict != null) {
                    try {
                        reusableDict = new DictionaryPage(BytesInput.from((byte[])dict.getBytes().toByteArray()), dict.getDictionarySize(), dict.getEncoding());
                    }
                    catch (IOException e) {
                        throw new ParquetDecodingException("Cannot read dictionary", (Throwable)e);
                    }
                }
                while ((page = reader.readPage()) != null) {
                    this.validateStatsForPage(page, reusableDict, desc);
                }
            }
        }

        private void validateStatsForPage(DataPage page, DictionaryPage dict, ColumnDescriptor desc) {
            SingletonPageReader reader = new SingletonPageReader(dict, page);
            PrimitiveConverter converter = CheckParquet251Command.this.getValidatingConverter(page, desc.getType());
            Statistics stats = CheckParquet251Command.getStatisticsFromPageHeader(page);
            long numNulls = 0L;
            ColumnReader column = (ColumnReader)COL_READER_CTOR.newInstance(new Object[]{desc, reader, converter, null});
            int i = 0;
            while ((long)i < reader.getTotalValueCount()) {
                if (column.getCurrentDefinitionLevel() >= desc.getMaxDefinitionLevel()) {
                    column.writeCurrentValueToConverter();
                } else {
                    ++numNulls;
                }
                column.consume();
                ++i;
            }
            if (numNulls != stats.getNumNulls()) {
                throw new BadStatsException("Number of nulls doesn't match.");
            }
            CheckParquet251Command.this.console.debug(String.format("Validated stats min=%s max=%s nulls=%d for page=%s col=%s", stats.minAsString(), stats.maxAsString(), stats.getNumNulls(), page, Arrays.toString(desc.getPath())));
        }
    }

    private class StatsValidator<T extends Comparable<T>> {
        private final boolean hasNonNull;
        private final T min;
        private final T max;
        private final Comparator<T> comparator;

        public StatsValidator(DataPage page) {
            Statistics stats = CheckParquet251Command.getStatisticsFromPageHeader(page);
            this.comparator = stats.comparator();
            this.hasNonNull = stats.hasNonNullValue();
            if (this.hasNonNull) {
                this.min = stats.genericGetMin();
                this.max = stats.genericGetMax();
            } else {
                this.min = null;
                this.max = null;
            }
        }

        public void validate(T value) {
            if (this.hasNonNull) {
                if (this.comparator.compare(this.min, value) > 0) {
                    throw new BadStatsException("Min should be <= all values.");
                }
                if (this.comparator.compare(this.max, value) < 0) {
                    throw new BadStatsException("Max should be >= all values.");
                }
            }
        }
    }

    public class SingletonPageReader
    implements PageReader {
        private final DictionaryPage dict;
        private final DataPage data;

        public SingletonPageReader(DictionaryPage dict, DataPage data) {
            this.dict = dict;
            this.data = data;
        }

        public DictionaryPage readDictionaryPage() {
            return this.dict;
        }

        public long getTotalValueCount() {
            return this.data.getValueCount();
        }

        public DataPage readPage() {
            return this.data;
        }
    }

    public static class BadStatsException
    extends RuntimeException {
        public BadStatsException(String message) {
            super(message);
        }
    }
}

