/*
 * Decompiled with CFR 0.152.
 */
package org.apache.parquet.cli;

import com.google.common.base.Ascii;
import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import com.google.common.collect.Iterables;
import com.google.common.hash.HashCode;
import java.util.Set;
import org.apache.parquet.column.ColumnDescriptor;
import org.apache.parquet.column.Encoding;
import org.apache.parquet.column.EncodingStats;
import org.apache.parquet.column.statistics.Statistics;
import org.apache.parquet.hadoop.metadata.CompressionCodecName;
import org.apache.parquet.schema.MessageType;
import org.apache.parquet.schema.OriginalType;
import org.apache.parquet.schema.PrimitiveType;

public class Util {
    private static final long KB = 1024L;
    private static final long MB = 0x100000L;
    private static final long GB = 0x40000000L;
    private static final long TB = 0x10000000000L;
    private static final Splitter DOT = Splitter.on((char)'.');

    public static String humanReadable(float bytes) {
        if (bytes > 1.0995116E12f) {
            return String.format("%.03f TB", Float.valueOf(bytes / 1.0995116E12f));
        }
        if (bytes > 1.0737418E9f) {
            return String.format("%.03f GB", Float.valueOf(bytes / 1.0737418E9f));
        }
        if (bytes > 1048576.0f) {
            return String.format("%.03f MB", Float.valueOf(bytes / 1048576.0f));
        }
        if (bytes > 1024.0f) {
            return String.format("%.03f kB", Float.valueOf(bytes / 1024.0f));
        }
        return String.format("%.02f B", Float.valueOf(bytes));
    }

    public static String humanReadable(long bytes) {
        if (bytes > 0x10000000000L) {
            return String.format("%.03f TB", Float.valueOf((float)bytes / 1.0995116E12f));
        }
        if (bytes > 0x40000000L) {
            return String.format("%.03f GB", Float.valueOf((float)bytes / 1.0737418E9f));
        }
        if (bytes > 0x100000L) {
            return String.format("%.03f MB", Float.valueOf((float)bytes / 1048576.0f));
        }
        if (bytes > 1024L) {
            return String.format("%.03f kB", Float.valueOf((float)bytes / 1024.0f));
        }
        return String.format("%d B", bytes);
    }

    @Deprecated
    public static String minMaxAsString(Statistics stats, OriginalType annotation) {
        return Util.minMaxAsString(stats);
    }

    public static String minMaxAsString(Statistics stats) {
        if (stats == null) {
            return "no stats";
        }
        if (!stats.hasNonNullValue()) {
            return "";
        }
        return String.format("%s / %s", Util.humanReadable(stats.minAsString(), 30), Util.humanReadable(stats.maxAsString(), 30));
    }

    @Deprecated
    public static String toString(Statistics stats, long count, OriginalType annotation) {
        return Util.toString(stats, count);
    }

    public static String toString(Statistics stats, long count) {
        if (stats == null) {
            return "no stats";
        }
        return String.format("min: %s max: %s nulls: %d/%d", Util.humanReadable(stats.minAsString(), 30), Util.humanReadable(stats.maxAsString(), 30), stats.getNumNulls(), count);
    }

    public static String humanReadable(String str, int len) {
        if (str == null) {
            return "null";
        }
        StringBuilder sb = new StringBuilder();
        sb.append("\"");
        if (str.length() > len - 2) {
            sb.append(str.substring(0, len - 5)).append("...");
        } else {
            sb.append(str);
        }
        sb.append("\"");
        return sb.toString();
    }

    public static String humanReadable(byte[] bytes, int len) {
        Preconditions.checkArgument((len >= 5 ? 1 : 0) != 0, (Object)"Display length must be minimum 5");
        if (bytes == null || bytes.length == 0) {
            return "null";
        }
        String asString = HashCode.fromBytes((byte[])bytes).toString();
        return "0x" + Ascii.truncate((CharSequence)asString, (int)(len - 2), (String)"...");
    }

    public static String shortCodec(CompressionCodecName codec) {
        switch (codec) {
            case UNCOMPRESSED: {
                return "_";
            }
            case SNAPPY: {
                return "S";
            }
            case GZIP: {
                return "G";
            }
            case LZO: {
                return "L";
            }
            case BROTLI: {
                return "B";
            }
            case LZ4: {
                return "4";
            }
            case ZSTD: {
                return "Z";
            }
        }
        return "?";
    }

    public static String encodingAsString(Encoding encoding, boolean isDict) {
        switch (encoding) {
            case PLAIN: {
                return "_";
            }
            case PLAIN_DICTIONARY: {
                return isDict ? "_" : "R";
            }
            case RLE_DICTIONARY: {
                return "R";
            }
            case DELTA_BINARY_PACKED: 
            case DELTA_LENGTH_BYTE_ARRAY: 
            case DELTA_BYTE_ARRAY: {
                return "D";
            }
        }
        return "?";
    }

    public static String encodingStatsAsString(EncodingStats encodingStats) {
        StringBuilder sb = new StringBuilder();
        if (encodingStats.hasDictionaryPages()) {
            for (Encoding encoding : encodingStats.getDictionaryEncodings()) {
                sb.append(Util.encodingAsString(encoding, true));
            }
            sb.append(" ");
        } else {
            sb.append("  ");
        }
        Set encodings = encodingStats.getDataEncodings();
        if (encodings.contains(Encoding.RLE_DICTIONARY) || encodings.contains(Encoding.PLAIN_DICTIONARY)) {
            sb.append("R");
        }
        if (encodings.contains(Encoding.PLAIN)) {
            sb.append("_");
        }
        if (encodings.contains(Encoding.DELTA_BYTE_ARRAY) || encodings.contains(Encoding.DELTA_BINARY_PACKED) || encodings.contains(org.apache.parquet.format.Encoding.DELTA_LENGTH_BYTE_ARRAY)) {
            sb.append("D");
        }
        if (encodingStats.hasDictionaryEncodedPages() && encodingStats.hasNonDictionaryEncodedPages()) {
            sb.append(" F");
        }
        return sb.toString();
    }

    public static String encodingsAsString(Set<Encoding> encodings, ColumnDescriptor desc) {
        StringBuilder sb = new StringBuilder();
        if (encodings.contains(Encoding.RLE) || encodings.contains(Encoding.BIT_PACKED)) {
            sb.append(desc.getMaxDefinitionLevel() == 0 ? "B" : "R");
            sb.append(desc.getMaxRepetitionLevel() == 0 ? "B" : "R");
            if (encodings.contains(Encoding.PLAIN_DICTIONARY)) {
                sb.append("R");
            }
            if (encodings.contains(Encoding.PLAIN)) {
                sb.append("_");
            }
        } else {
            sb.append("RR");
            if (encodings.contains(Encoding.RLE_DICTIONARY)) {
                sb.append("R");
            }
            if (encodings.contains(Encoding.PLAIN)) {
                sb.append("_");
            }
            if (encodings.contains(Encoding.DELTA_BYTE_ARRAY) || encodings.contains(Encoding.DELTA_BINARY_PACKED) || encodings.contains(org.apache.parquet.format.Encoding.DELTA_LENGTH_BYTE_ARRAY)) {
                sb.append("D");
            }
        }
        return sb.toString();
    }

    public static ColumnDescriptor descriptor(String column, MessageType schema) {
        String[] path = (String[])Iterables.toArray((Iterable)DOT.split((CharSequence)column), String.class);
        Preconditions.checkArgument((boolean)schema.containsPath(path), (Object)("Schema doesn't have column: " + column));
        return schema.getColumnDescription(path);
    }

    public static String columnName(ColumnDescriptor desc) {
        return Joiner.on((char)'.').join((Object[])desc.getPath());
    }

    public static PrimitiveType primitive(MessageType schema, String[] path) {
        MessageType current = schema;
        for (String part : path) {
            if (!(current = current.asGroupType().getType(part)).isPrimitive()) continue;
            return current.asPrimitiveType();
        }
        return null;
    }

    public static PrimitiveType primitive(String column, MessageType schema) {
        String[] path = (String[])Iterables.toArray((Iterable)DOT.split((CharSequence)column), String.class);
        Preconditions.checkArgument((boolean)schema.containsPath(path), (Object)("Schema doesn't have column: " + column));
        return Util.primitive(schema, path);
    }
}

