/*
 * Decompiled with CFR 0.152.
 */
package org.apache.parquet.cli.commands;

import com.beust.jcommander.JCommander;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import org.apache.parquet.cli.commands.AvroFileTest;
import org.apache.parquet.cli.commands.ToAvroCommand;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;

public class ToAvroCommandTest
extends AvroFileTest {
    @Rule
    public TemporaryFolder folder = new TemporaryFolder();

    @Test
    public void testToAvroCommandFromParquet() throws IOException {
        File avroFile = this.toAvro(this.parquetFile());
        Assert.assertTrue((boolean)avroFile.exists());
    }

    @Test
    public void testToAvroCommandFromJson() throws IOException {
        File jsonInputFile = this.folder.newFile("sample.json");
        File avroOutputFile = this.folder.newFile("sample.avro");
        String inputJson = "{\"id\": 1, \"name\": \"Alice\"}\n{\"id\": 2, \"name\": \"Bob\"}\n{\"id\": 3, \"name\": \"Carol\"}\n{\"id\": 4, \"name\": \"Dave\"}";
        try (BufferedWriter writer = new BufferedWriter(new FileWriter(jsonInputFile));){
            writer.write("{\"id\": 1, \"name\": \"Alice\"}\n{\"id\": 2, \"name\": \"Bob\"}\n{\"id\": 3, \"name\": \"Carol\"}\n{\"id\": 4, \"name\": \"Dave\"}");
        }
        ToAvroCommand cmd = new ToAvroCommand(null);
        JCommander.newBuilder().addObject((Object)cmd).build().parse(new String[]{jsonInputFile.getAbsolutePath(), "--output", avroOutputFile.getAbsolutePath()});
        assert (cmd.run() == 0);
    }

    public void testToAvroCommandWithGzipCompression() throws IOException {
        File avroFile = this.toAvro(this.parquetFile(), "GZIP");
        Assert.assertTrue((boolean)avroFile.exists());
    }

    @Test
    public void testToAvroCommandWithSnappyCompression() throws IOException {
        File avroFile = this.toAvro(this.parquetFile(), "SNAPPY");
        Assert.assertTrue((boolean)avroFile.exists());
    }

    @Test
    public void testToAvroCommandWithZstdCompression() throws IOException {
        File avroFile = this.toAvro(this.parquetFile(), "ZSTD");
        Assert.assertTrue((boolean)avroFile.exists());
    }

    @Test(expected=IllegalArgumentException.class)
    public void testToAvroCommandWithInvalidCompression() throws IOException {
        this.toAvro(this.parquetFile(), "FOO");
    }
}

