/*
 * Decompiled with CFR 0.152.
 */
package org.apache.parquet.cli.commands;

import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import org.apache.hadoop.conf.Configuration;
import org.apache.parquet.cli.commands.ParquetFileTest;
import org.apache.parquet.cli.commands.ToAvroCommand;

public class AvroFileTest
extends ParquetFileTest {
    protected File toAvro(File parquetFile) throws IOException {
        return this.toAvro(parquetFile, "GZIP");
    }

    protected File toAvro(File parquetFile, String compressionCodecName) throws IOException {
        ToAvroCommand command = new ToAvroCommand(AvroFileTest.createLogger());
        command.targets = Arrays.asList(parquetFile.getAbsolutePath());
        File output = new File(this.getTempFolder(), this.getClass().getSimpleName() + ".avro");
        command.outputPath = output.getAbsolutePath();
        command.compressionCodecName = compressionCodecName;
        command.setConf(new Configuration());
        int exitCode = command.run();
        assert (exitCode == 0);
        return output;
    }
}

