/*
 * Decompiled with CFR 0.152.
 */
package org.apache.parquet.cli.commands;

import com.beust.jcommander.Parameter;
import com.beust.jcommander.Parameters;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.io.Closeables;
import java.io.Closeable;
import java.io.IOException;
import java.io.OutputStream;
import java.util.List;
import org.apache.avro.Schema;
import org.apache.avro.file.CodecFactory;
import org.apache.avro.file.DataFileWriter;
import org.apache.avro.generic.GenericData;
import org.apache.avro.generic.GenericDatumWriter;
import org.apache.avro.io.DatumWriter;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.parquet.cli.BaseCommand;
import org.apache.parquet.cli.util.Codecs;
import org.apache.parquet.cli.util.Expressions;
import org.apache.parquet.cli.util.Schemas;
import org.slf4j.Logger;

@Parameters(commandDescription="Create an Avro file from a data file")
public class ToAvroCommand
extends BaseCommand {
    @Parameter(description="<file>")
    List<String> targets;
    @Parameter(names={"-o", "--output"}, description="Output file path", required=true)
    String outputPath = null;
    @Parameter(names={"-s", "--schema"}, description="The file containing an Avro schema for the output file")
    String avroSchemaFile;
    @Parameter(names={"-c", "--column", "--columns"}, description="List of columns")
    List<String> columns;
    @Parameter(names={"--compression-codec"}, description="A compression codec name.")
    String compressionCodecName = "GZIP";
    @Parameter(names={"--overwrite"}, description="Overwrite the output file if it exists")
    boolean overwrite = false;

    public ToAvroCommand(Logger console) {
        super(console);
    }

    @Override
    public int run() throws IOException {
        Preconditions.checkArgument((this.targets != null && this.targets.size() == 1 ? 1 : 0) != 0, (Object)"A data file is required.");
        String source = this.targets.get(0);
        CodecFactory codecFactory = Codecs.avroCodec(this.compressionCodecName);
        Schema schema = this.avroSchemaFile != null ? Schemas.fromAvsc(this.open(this.avroSchemaFile)) : this.getAvroSchema(source);
        Schema projection = Expressions.filterSchema(schema, this.columns);
        Path outPath = this.qualifiedPath(this.outputPath);
        FileSystem outFS = outPath.getFileSystem(this.getConf());
        if (this.overwrite && outFS.exists(outPath)) {
            this.console.debug("Deleting output file {} (already exists)", (Object)outPath);
            outFS.delete(outPath);
        }
        Iterable reader = this.openDataFile(source, projection);
        boolean threw = true;
        long count = 0L;
        try {
            GenericDatumWriter datumWriter = new GenericDatumWriter(schema);
            DataFileWriter w = new DataFileWriter((DatumWriter)datumWriter);
            w.setCodec(codecFactory);
            try (DataFileWriter writer = w.create(projection, (OutputStream)this.create(this.outputPath));){
                for (GenericData.Record record : reader) {
                    writer.append((Object)record);
                    ++count;
                }
            }
            threw = false;
        }
        catch (RuntimeException e) {
            throw new RuntimeException("Failed on record " + count, e);
        }
        finally {
            if (reader instanceof Closeable) {
                Closeables.close((Closeable)((Closeable)((Object)reader)), (boolean)threw);
            }
        }
        return 0;
    }

    @Override
    public List<String> getExamples() {
        return Lists.newArrayList((Object[])new String[]{"# Create an Avro file from a Parquet file", "sample.parquet sample.avro", "# Create an Avro file in HDFS from a local JSON file", "path/to/sample.json hdfs:/user/me/sample.parquet", "# Create an Avro file from data in S3", "s3:/data/path/sample.parquet sample.avro"});
    }
}

