/*
 * Decompiled with CFR 0.152.
 */
package shaded.parquet.org.apache.avro.reflect;

import shaded.parquet.org.apache.avro.AvroRuntimeException;
import shaded.parquet.org.apache.avro.reflect.FieldAccess;
import shaded.parquet.org.apache.avro.reflect.FieldAccessor;

class ReflectionUtil {
    private static FieldAccess fieldAccess;

    private ReflectionUtil() {
    }

    static void resetFieldAccess() {
        FieldAccess access = null;
        try {
            FieldAccess unsafeAccess;
            if (null == System.getProperty("avro.disable.unsafe") && ReflectionUtil.validate(unsafeAccess = ReflectionUtil.load("shaded.parquet.org.apache.avro.reflect.FieldAccessUnsafe", FieldAccess.class))) {
                access = unsafeAccess;
            }
        }
        catch (Throwable unsafeAccess) {
            // empty catch block
        }
        if (access == null) {
            try {
                FieldAccess reflectAccess = ReflectionUtil.load("shaded.parquet.org.apache.avro.reflect.FieldAccessReflect", FieldAccess.class);
                if (ReflectionUtil.validate(reflectAccess)) {
                    access = reflectAccess;
                }
            }
            catch (Throwable oops) {
                throw new AvroRuntimeException("Unable to load a functional FieldAccess class!");
            }
        }
        fieldAccess = access;
    }

    private static <T> T load(String name, Class<T> type) throws Exception {
        return ReflectionUtil.class.getClassLoader().loadClass(name).asSubclass(type).newInstance();
    }

    public static FieldAccess getFieldAccess() {
        return fieldAccess;
    }

    private static boolean validate(FieldAccess access) throws Exception {
        return new AccessorTestClass().validate(access);
    }

    static {
        ReflectionUtil.resetFieldAccess();
    }

    private static final class AccessorTestClass {
        private boolean b = true;
        protected byte by = (byte)15;
        public char c = (char)99;
        short s = (short)123;
        int i = 999;
        long l = 12345L;
        float f = 2.2f;
        double d = 4.4;
        Object o = "foo";
        Integer i2 = 555;

        private AccessorTestClass() {
        }

        private boolean validate(FieldAccess access) throws Exception {
            boolean valid = true;
            valid &= this.validField(access, "b", this.b, false);
            valid &= this.validField(access, "by", this.by, (byte)-81);
            valid &= this.validField(access, "c", Character.valueOf(this.c), Character.valueOf('C'));
            valid &= this.validField(access, "s", this.s, (short)321);
            valid &= this.validField(access, "i", this.i, 111);
            valid &= this.validField(access, "l", this.l, 54321L);
            valid &= this.validField(access, "f", Float.valueOf(this.f), Float.valueOf(0.2f));
            valid &= this.validField(access, "d", this.d, 0.4);
            valid &= this.validField(access, "o", this.o, new Object());
            return valid &= this.validField(access, "i2", this.i2, -555);
        }

        private boolean validField(FieldAccess access, String name, Object original, Object toSet) throws Exception {
            boolean valid = true;
            FieldAccessor a = this.accessor(access, name);
            valid &= original.equals(a.get(this));
            a.set(this, toSet);
            return valid &= !original.equals(a.get(this));
        }

        private FieldAccessor accessor(FieldAccess access, String name) throws Exception {
            return access.getAccessor(this.getClass().getDeclaredField(name));
        }
    }
}

