/*
 * Decompiled with CFR 0.152.
 */
package org.apache.parquet.cli.csv;

import java.util.List;
import org.apache.parquet.cli.util.RecordException;
import org.apache.parquet.cli.util.Schemas;
import shaded.parquet.org.apache.avro.AvroRuntimeException;
import shaded.parquet.org.apache.avro.Schema;
import shaded.parquet.org.apache.avro.generic.GenericData;
import shaded.parquet.org.apache.avro.generic.IndexedRecord;
import shaded.parquet.org.apache.avro.reflect.ReflectData;

class RecordBuilder<E> {
    private final Schema schema;
    private final Class<E> recordClass;
    private final Schema.Field[] fields;
    private final int[] indexes;

    public RecordBuilder(Schema schema, Class<E> recordClass, List<String> header) {
        this.schema = schema;
        this.recordClass = recordClass;
        this.fields = schema.getFields().toArray(new Schema.Field[schema.getFields().size()]);
        this.indexes = new int[this.fields.length];
        if (header != null) {
            int i;
            for (i = 0; i < this.fields.length; ++i) {
                this.fields[i] = schema.getFields().get(i);
                this.indexes[i] = Integer.MAX_VALUE;
            }
            for (i = 0; i < header.size(); ++i) {
                Schema.Field field = schema.getField(header.get(i));
                if (field == null) continue;
                this.indexes[field.pos()] = i;
            }
        } else {
            for (int i = 0; i < this.fields.length; ++i) {
                this.fields[i] = schema.getFields().get(i);
                this.indexes[i] = i;
            }
        }
    }

    public E makeRecord(String[] fields, E reuse) {
        E record = reuse;
        if (record == null) {
            record = this.newRecordInstance();
        }
        if (record instanceof IndexedRecord) {
            this.fillIndexed((IndexedRecord)record, fields);
        } else {
            this.fillReflect(record, fields);
        }
        return record;
    }

    private E newRecordInstance() {
        Object record;
        if (this.recordClass != GenericData.Record.class && !this.recordClass.isInterface() && (record = ReflectData.newInstance(this.recordClass, this.schema)) != null) {
            return (E)record;
        }
        return (E)new GenericData.Record(this.schema);
    }

    private void fillIndexed(IndexedRecord record, String[] data) {
        for (int i = 0; i < this.indexes.length; ++i) {
            int index = this.indexes[i];
            record.put(i, RecordBuilder.makeValue(index < data.length ? data[index] : null, this.fields[i]));
        }
    }

    private void fillReflect(Object record, String[] data) {
        for (int i = 0; i < this.indexes.length; ++i) {
            Schema.Field field = this.fields[i];
            int index = this.indexes[i];
            Object value = RecordBuilder.makeValue(index < data.length ? data[index] : null, field);
            ReflectData.get().setField(record, field.name(), i, value);
        }
    }

    private static Object makeValue(String string, Schema.Field field) {
        try {
            Object value = RecordBuilder.makeValue(string, field.schema());
            if (value != null || Schemas.nullOk(field.schema())) {
                return value;
            }
            return ReflectData.get().getDefaultValue(field);
        }
        catch (RecordException e) {
            throw new RecordException(String.format("Cannot convert field %s", field.name()), e);
        }
        catch (NumberFormatException e) {
            throw new RecordException(String.format("Field %s: value not a %s: '%s'", field.name(), field.schema(), string), e);
        }
        catch (AvroRuntimeException e) {
            throw new RecordException(String.format("Field %s: cannot make %s value: '%s'", field.name(), field.schema(), string), e);
        }
    }

    private static Object makeValue(String string, Schema schema) {
        if (string == null) {
            return null;
        }
        try {
            switch (schema.getType()) {
                case BOOLEAN: {
                    return Boolean.valueOf(string);
                }
                case STRING: {
                    return string;
                }
                case FLOAT: {
                    return Float.valueOf(string);
                }
                case DOUBLE: {
                    return Double.valueOf(string);
                }
                case INT: {
                    return Integer.valueOf(string);
                }
                case LONG: {
                    return Long.valueOf(string);
                }
                case ENUM: {
                    if (schema.hasEnumSymbol(string)) {
                        return string;
                    }
                    try {
                        return schema.getEnumSymbols().get(Integer.parseInt(string));
                    }
                    catch (IndexOutOfBoundsException ex) {
                        return null;
                    }
                }
                case UNION: {
                    Object value = null;
                    for (Schema possible : schema.getTypes()) {
                        value = RecordBuilder.makeValue(string, possible);
                        if (value == null) continue;
                        return value;
                    }
                    return null;
                }
                case NULL: {
                    return null;
                }
            }
            throw new RecordException("Unsupported field type:" + (Object)((Object)schema.getType()));
        }
        catch (NumberFormatException e) {
            if (string.isEmpty()) {
                return null;
            }
            throw e;
        }
    }
}

