/*
 * Decompiled with CFR 0.152.
 */
package org.apache.parquet.cli.commands;

import com.beust.jcommander.Parameter;
import com.beust.jcommander.Parameters;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.List;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.parquet.cli.BaseCommand;
import org.apache.parquet.cli.util.Formats;
import org.apache.parquet.format.converter.ParquetMetadataConverter;
import org.apache.parquet.hadoop.ParquetFileReader;
import org.slf4j.Logger;
import shaded.parquet.org.apache.avro.file.SeekableInput;

@Parameters(commandDescription="Print the Avro schema for a file")
public class SchemaCommand
extends BaseCommand {
    @Parameter(description="<parquet path>")
    List<String> targets;
    @Parameter(names={"-o", "--output"}, description="Output file path")
    String outputPath = null;
    @Parameter(names={"--overwrite"}, description="Overwrite the output file if it exists")
    boolean overwrite = false;
    @Parameter(names={"--parquet"}, description="Print a Parquet schema, without converting to Avro", hidden=true)
    boolean parquetSchema = false;

    public SchemaCommand(Logger console) {
        super(console);
    }

    @Override
    public int run() throws IOException {
        Preconditions.checkArgument((this.targets != null && this.targets.size() == 1 ? 1 : 0) != 0, (Object)"Parquet file is required.");
        if (this.targets.size() > 1) {
            Preconditions.checkArgument((this.outputPath == null ? 1 : 0) != 0, (Object)("Cannot output multiple schemas to file " + this.outputPath));
            for (String source : this.targets) {
                this.console.info("{}: {}", (Object)source, (Object)this.getSchema(source));
            }
        } else {
            String source = this.targets.get(0);
            if (this.outputPath != null) {
                Path outPath = this.qualifiedPath(this.outputPath);
                FileSystem outFS = outPath.getFileSystem(this.getConf());
                if (this.overwrite && outFS.exists(outPath)) {
                    this.console.debug("Deleting output file {} (already exists)", (Object)outPath);
                    outFS.delete(outPath);
                }
                try (FSDataOutputStream out = this.create(this.outputPath);){
                    out.write(this.getSchema(source).getBytes(StandardCharsets.UTF_8));
                }
            } else {
                this.console.info(this.getSchema(source));
            }
        }
        return 0;
    }

    @Override
    public List<String> getExamples() {
        return Lists.newArrayList((Object[])new String[]{"# Print the Avro schema for a Parquet file", "sample.parquet", "# Print the Avro schema for an Avro file", "sample.avro", "# Print the Avro schema for a JSON file", "sample.json"});
    }

    private String getSchema(String source) throws IOException {
        if (this.parquetSchema) {
            return this.getParquetSchema(source);
        }
        return this.getAvroSchema(source).toString(true);
    }

    private String getParquetSchema(String source) throws IOException {
        Throwable throwable = null;
        try (SeekableInput in = this.openSeekable(source);){
            Formats.Format format = Formats.detectFormat((InputStream)((Object)in));
            in.seek(0L);
            switch (format) {
                case PARQUET: {
                    String string = new ParquetFileReader(this.getConf(), this.qualifiedPath(source), ParquetMetadataConverter.NO_FILTER).getFileMetaData().getSchema().toString();
                    return string;
                }
            }
            try {
                throw new IllegalArgumentException(String.format("Could not get a Parquet schema for format %s: %s", new Object[]{format, source}));
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
        }
    }
}

