/*
 * Decompiled with CFR 0.152.
 */
package org.apache.parquet.cli.commands;

import com.beust.jcommander.Parameter;
import com.beust.jcommander.Parameters;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import org.apache.commons.lang.StringUtils;
import org.apache.parquet.cli.BaseCommand;
import org.apache.parquet.cli.Util;
import org.apache.parquet.column.ColumnDescriptor;
import org.apache.parquet.column.Encoding;
import org.apache.parquet.column.EncodingStats;
import org.apache.parquet.column.statistics.Statistics;
import org.apache.parquet.format.converter.ParquetMetadataConverter;
import org.apache.parquet.hadoop.ParquetFileReader;
import org.apache.parquet.hadoop.metadata.BlockMetaData;
import org.apache.parquet.hadoop.metadata.ColumnChunkMetaData;
import org.apache.parquet.hadoop.metadata.CompressionCodecName;
import org.apache.parquet.hadoop.metadata.ParquetMetadata;
import org.apache.parquet.schema.MessageType;
import org.apache.parquet.schema.PrimitiveType;
import org.slf4j.Logger;

@Parameters(commandDescription="Print a Parquet file's metadata")
public class ParquetMetadataCommand
extends BaseCommand {
    @Parameter(description="<parquet path>")
    List<String> targets;

    public ParquetMetadataCommand(Logger console) {
        super(console);
    }

    @Override
    public int run() throws IOException {
        Preconditions.checkArgument((this.targets != null && this.targets.size() >= 1 ? 1 : 0) != 0, (Object)"A Parquet file is required.");
        Preconditions.checkArgument((this.targets.size() == 1 ? 1 : 0) != 0, (Object)"Cannot process multiple Parquet files.");
        String source = this.targets.get(0);
        ParquetMetadata footer = ParquetFileReader.readFooter(this.getConf(), this.qualifiedPath(source), ParquetMetadataConverter.NO_FILTER);
        this.console.info("\nFile path:  {}", (Object)source);
        this.console.info("Created by: {}", (Object)footer.getFileMetaData().getCreatedBy());
        Map<String, String> kv = footer.getFileMetaData().getKeyValueMetaData();
        if (kv != null && !kv.isEmpty()) {
            this.console.info("Properties:");
            String format = "  %" + this.maxSize(kv.keySet()) + "s: %s";
            for (Map.Entry<String, String> entry : kv.entrySet()) {
                this.console.info(String.format(format, entry.getKey(), entry.getValue()));
            }
        } else {
            this.console.info("Properties: (none)");
        }
        MessageType schema = footer.getFileMetaData().getSchema();
        this.console.info("Schema:\n{}", (Object)schema);
        List<BlockMetaData> rowGroups = footer.getBlocks();
        int n = rowGroups.size();
        for (int index = 0; index < n; ++index) {
            this.printRowGroup(this.console, index, rowGroups.get(index), schema);
        }
        this.console.info("");
        return 0;
    }

    @Override
    public List<String> getExamples() {
        return Lists.newArrayList();
    }

    private int maxSize(Iterable<String> strings) {
        int size = 0;
        for (String s : strings) {
            size = Math.max(size, s.length());
        }
        return size;
    }

    private void printRowGroup(Logger console, int index, BlockMetaData rowGroup, MessageType schema) {
        long start = rowGroup.getStartingPos();
        long rowCount = rowGroup.getRowCount();
        long compressedSize = rowGroup.getCompressedSize();
        long uncompressedSize = rowGroup.getTotalByteSize();
        String filePath = rowGroup.getPath();
        console.info(String.format("\nRow group %d:  count: %d  %s records  start: %d  total: %s%s\n%s", index, rowCount, Util.humanReadable((float)compressedSize / (float)rowCount), start, Util.humanReadable(compressedSize), filePath != null ? " path: " + filePath : "", StringUtils.leftPad((String)"", (int)80, (char)'-')));
        int size = this.maxSize(Iterables.transform(rowGroup.getColumns(), (Function)new Function<ColumnChunkMetaData, String>(){

            public String apply(@Nullable ColumnChunkMetaData input) {
                return input == null ? "" : input.getPath().toDotString();
            }
        }));
        console.info(String.format("%-" + size + "s  %-9s %-9s %-9s %-10s %-7s %s", "", "type", "encodings", "count", "avg size", "nulls", "min / max"));
        for (ColumnChunkMetaData column : rowGroup.getColumns()) {
            this.printColumnChunk(console, size, column, schema);
        }
    }

    private void printColumnChunk(Logger console, int width, ColumnChunkMetaData column, MessageType schema) {
        String[] path = column.getPath().toArray();
        PrimitiveType type = Util.primitive(schema, path);
        Preconditions.checkNotNull((Object)type);
        ColumnDescriptor desc = schema.getColumnDescription(path);
        long size = column.getTotalSize();
        long count = column.getValueCount();
        float perValue = (float)size / (float)count;
        CompressionCodecName codec = column.getCodec();
        Set<Encoding> encodings = column.getEncodings();
        EncodingStats encodingStats = column.getEncodingStats();
        String encodingSummary = encodingStats == null ? Util.encodingsAsString(encodings, desc) : Util.encodingStatsAsString(encodingStats);
        Statistics stats = column.getStatistics();
        String name = column.getPath().toDotString();
        PrimitiveType.PrimitiveTypeName typeName = type.getPrimitiveTypeName();
        if (typeName == PrimitiveType.PrimitiveTypeName.FIXED_LEN_BYTE_ARRAY) {
            console.info(String.format("%-" + width + "s  FIXED[%d] %s %-7s %-9d %-8s %-7s %s", name, type.getTypeLength(), Util.shortCodec(codec), encodingSummary, count, Util.humanReadable(perValue), stats == null || !stats.isNumNullsSet() ? "" : String.valueOf(stats.getNumNulls()), Util.minMaxAsString(stats, type.getOriginalType())));
        } else {
            console.info(String.format("%-" + width + "s  %-9s %s %-7s %-9d %-10s %-7s %s", new Object[]{name, typeName, Util.shortCodec(codec), encodingSummary, count, Util.humanReadable(perValue), stats == null || !stats.isNumNullsSet() ? "" : String.valueOf(stats.getNumNulls()), Util.minMaxAsString(stats, type.getOriginalType())}));
        }
    }
}

