/*
 * Decompiled with CFR 0.152.
 */
package org.apache.parquet.cli;

import com.beust.jcommander.JCommander;
import com.beust.jcommander.MissingCommandException;
import com.beust.jcommander.Parameter;
import com.beust.jcommander.ParameterException;
import com.beust.jcommander.Parameters;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableSet;
import java.net.URL;
import java.util.Set;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configurable;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.conf.Configured;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;
import org.apache.log4j.Level;
import org.apache.log4j.PropertyConfigurator;
import org.apache.parquet.cli.Command;
import org.apache.parquet.cli.Help;
import org.apache.parquet.cli.commands.CSVSchemaCommand;
import org.apache.parquet.cli.commands.CatCommand;
import org.apache.parquet.cli.commands.CheckParquet251Command;
import org.apache.parquet.cli.commands.ConvertCSVCommand;
import org.apache.parquet.cli.commands.ConvertCommand;
import org.apache.parquet.cli.commands.ParquetMetadataCommand;
import org.apache.parquet.cli.commands.SchemaCommand;
import org.apache.parquet.cli.commands.ShowDictionaryCommand;
import org.apache.parquet.cli.commands.ShowPagesCommand;
import org.apache.parquet.cli.commands.ToAvroCommand;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Parameters(commandDescription="Parquet file utils")
public class Main
extends Configured
implements Tool {
    @Parameter(names={"-v", "--verbose", "--debug"}, description="Print extra debugging information")
    private boolean debug = false;
    @Parameter(names={"--dollar-zero"}, description="A way for the runtime path to be passed in", hidden=true)
    @VisibleForTesting
    String programName = "parquet";
    @VisibleForTesting
    static final String DEFAULT_PROGRAM_NAME = "parquet";
    private static Set<String> HELP_ARGS = ImmutableSet.of((Object)"-h", (Object)"-help", (Object)"--help", (Object)"help");
    private final Logger console;
    private final Help help;
    @VisibleForTesting
    final JCommander jc;

    Main(Logger console) {
        this.console = console;
        this.jc = new JCommander((Object)this);
        this.help = new Help(this.jc, console);
        this.jc.setProgramName(DEFAULT_PROGRAM_NAME);
        this.jc.addCommand("help", this.help, "-h", "-help", "--help");
        this.jc.addCommand("meta", new ParquetMetadataCommand(console));
        this.jc.addCommand("pages", new ShowPagesCommand(console));
        this.jc.addCommand("dictionary", new ShowDictionaryCommand(console));
        this.jc.addCommand("check-stats", new CheckParquet251Command(console));
        this.jc.addCommand("schema", new SchemaCommand(console));
        this.jc.addCommand("csv-schema", new CSVSchemaCommand(console));
        this.jc.addCommand("convert-csv", new ConvertCSVCommand(console));
        this.jc.addCommand("convert", new ConvertCommand(console));
        this.jc.addCommand("to-avro", new ToAvroCommand(console));
        this.jc.addCommand("cat", new CatCommand(console, 0L));
        this.jc.addCommand("head", new CatCommand(console, 10L));
    }

    public int run(String[] args) throws Exception {
        String parsed;
        try {
            this.jc.parse(args);
        }
        catch (MissingCommandException e) {
            this.console.error(e.getMessage());
            return 1;
        }
        catch (ParameterException e) {
            this.help.setProgramName(this.programName);
            String cmd = this.jc.getParsedCommand();
            if (args.length == 1) {
                this.help.helpCommands.add(cmd);
                this.help.run();
                return 1;
            }
            for (String arg : args) {
                if (!HELP_ARGS.contains(arg)) continue;
                this.help.helpCommands.add(cmd);
                this.help.run();
                return 0;
            }
            this.console.error(e.getMessage());
            return 1;
        }
        this.help.setProgramName(this.programName);
        if (this.debug) {
            org.apache.log4j.Logger console = org.apache.log4j.Logger.getLogger(Main.class);
            console.setLevel(Level.DEBUG);
        }
        if ((parsed = this.jc.getParsedCommand()) == null) {
            this.help.run();
            return 1;
        }
        if ("help".equals(parsed)) {
            return this.help.run();
        }
        Command command = (Command)this.jc.getCommands().get(parsed).getObjects().get(0);
        if (command == null) {
            this.help.run();
            return 1;
        }
        try {
            if (command instanceof Configurable) {
                ((Configurable)command).setConf(this.getConf());
            }
            return command.run();
        }
        catch (IllegalArgumentException e) {
            if (this.debug) {
                this.console.error("Argument error", e);
            } else {
                this.console.error("Argument error: {}", (Object)e.getMessage());
            }
            return 1;
        }
        catch (IllegalStateException e) {
            if (this.debug) {
                this.console.error("State error", e);
            } else {
                this.console.error("State error: {}", (Object)e.getMessage());
            }
            return 1;
        }
        catch (Exception e) {
            this.console.error("Unknown error", e);
            return 1;
        }
    }

    public static void main(String[] args) throws Exception {
        PropertyConfigurator.configure((URL)Main.class.getResource("/cli-logging.properties"));
        Logger console = LoggerFactory.getLogger(Main.class);
        LogFactory.getFactory().setAttribute("org.apache.commons.logging.Log", (Object)"org.apache.commons.logging.impl.Log4JLogger");
        int rc = ToolRunner.run((Configuration)new Configuration(), (Tool)new Main(console), (String[])args);
        System.exit(rc);
    }
}

