/*
 * Decompiled with CFR 0.152.
 */
package org.apache.webbeans.test.unittests.xml.strict;

import java.io.InputStream;
import junit.framework.Assert;
import org.apache.webbeans.component.AbstractInjectionTargetBean;
import org.apache.webbeans.exception.WebBeansConfigurationException;
import org.apache.webbeans.inject.AlternativesManager;
import org.apache.webbeans.test.TestContext;
import org.apache.webbeans.test.unittests.xml.XMLTest;
import org.apache.webbeans.test.xml.strict.Alternative1;
import org.apache.webbeans.test.xml.strict.Alternative2;
import org.apache.webbeans.xml.WebBeansXMLConfigurator;
import org.junit.Test;

public class AlternativesTest
extends TestContext {
    public AlternativesTest() {
        super(AlternativesTest.class.getName());
    }

    @Test
    public void testAlternativeCorrect() {
        AbstractInjectionTargetBean<Alternative1> alternative1 = this.defineManagedBean(Alternative1.class);
        AbstractInjectionTargetBean<Alternative2> alternative2 = this.defineManagedBean(Alternative2.class);
        InputStream stream = XMLTest.class.getClassLoader().getResourceAsStream("org/apache/webbeans/test/xml/strict/alternatives_correct.xml");
        Assert.assertNotNull((Object)stream);
        WebBeansXMLConfigurator configurator = new WebBeansXMLConfigurator();
        configurator.configureSpecSpecific(stream, "alternatives_correct.xml");
        AlternativesManager manager = AlternativesManager.getInstance();
        Assert.assertTrue((boolean)manager.isBeanHasAlternative(alternative1));
        Assert.assertTrue((boolean)manager.isBeanHasAlternative(alternative2));
        manager.clear();
    }

    @Test(expected=WebBeansConfigurationException.class)
    public void testDoubleAlternativeClass() {
        InputStream stream = XMLTest.class.getClassLoader().getResourceAsStream("org/apache/webbeans/test/xml/strict/alternatives_failed.xml");
        Assert.assertNotNull((Object)stream);
        WebBeansXMLConfigurator configurator = new WebBeansXMLConfigurator();
        configurator.configureSpecSpecific(stream, "alternatives_failed.xml");
    }

    @Test(expected=WebBeansConfigurationException.class)
    public void testDoubleAlternativeStereotype() {
        InputStream stream = XMLTest.class.getClassLoader().getResourceAsStream("org/apache/webbeans/test/xml/strict/alternatives_failed2.xml");
        Assert.assertNotNull((Object)stream);
        WebBeansXMLConfigurator configurator = new WebBeansXMLConfigurator();
        configurator.configureSpecSpecific(stream, "alternatives_failed2.xml");
    }

    @Test(expected=WebBeansConfigurationException.class)
    public void testNoClass() {
        InputStream stream = XMLTest.class.getClassLoader().getResourceAsStream("org/apache/webbeans/test/xml/strict/alternatives_failed3.xml");
        Assert.assertNotNull((Object)stream);
        WebBeansXMLConfigurator configurator = new WebBeansXMLConfigurator();
        configurator.configureSpecSpecific(stream, "alternatives_failed3.xml");
    }

    @Test(expected=WebBeansConfigurationException.class)
    public void testNoStereotype() {
        InputStream stream = XMLTest.class.getClassLoader().getResourceAsStream("org/apache/webbeans/test/xml/strict/alternatives_failed4.xml");
        Assert.assertNotNull((Object)stream);
        WebBeansXMLConfigurator configurator = new WebBeansXMLConfigurator();
        configurator.configureSpecSpecific(stream, "alternatives_failed4.xml");
    }

    @Test(expected=WebBeansConfigurationException.class)
    public void testNotAnnotationClass() {
        InputStream stream = XMLTest.class.getClassLoader().getResourceAsStream("org/apache/webbeans/test/xml/strict/alternatives_failed5.xml");
        Assert.assertNotNull((Object)stream);
        WebBeansXMLConfigurator configurator = new WebBeansXMLConfigurator();
        configurator.configureSpecSpecific(stream, "alternatives_failed5.xml");
    }

    @Test(expected=WebBeansConfigurationException.class)
    public void testNotStereotype() {
        InputStream stream = XMLTest.class.getClassLoader().getResourceAsStream("org/apache/webbeans/test/xml/strict/alternatives_failed6.xml");
        Assert.assertNotNull((Object)stream);
        WebBeansXMLConfigurator configurator = new WebBeansXMLConfigurator();
        configurator.configureSpecSpecific(stream, "alternatives_failed6.xml");
    }
}

