/*
 * Decompiled with CFR 0.152.
 */
package org.apache.webbeans.test.unittests.specializes.logger;

import java.io.InputStream;
import java.lang.reflect.Type;
import java.util.ArrayList;
import javax.enterprise.inject.spi.Bean;
import junit.framework.Assert;
import org.apache.webbeans.component.AbstractInjectionTargetBean;
import org.apache.webbeans.inject.AlternativesManager;
import org.apache.webbeans.plugins.PluginLoader;
import org.apache.webbeans.test.TestContext;
import org.apache.webbeans.test.component.specializes.logger.ISomeLogger;
import org.apache.webbeans.test.component.specializes.logger.MockNotSpecializedLogger;
import org.apache.webbeans.test.component.specializes.logger.MockSpecializedLogger;
import org.apache.webbeans.test.component.specializes.logger.SpecializedInjector;
import org.apache.webbeans.test.component.specializes.logger.SystemLogger;
import org.apache.webbeans.test.unittests.xml.XMLTest;
import org.apache.webbeans.util.WebBeansUtil;
import org.apache.webbeans.xml.WebBeansXMLConfigurator;
import org.junit.Test;

public class LoggerSpecializationTest
extends TestContext {
    public LoggerSpecializationTest() {
        super(LoggerSpecializationTest.class.getName());
    }

    @Test
    public void testNotSpecializedVersion() {
        this.clear();
        PluginLoader.getInstance().startUp();
        InputStream stream = XMLTest.class.getClassLoader().getResourceAsStream("org/apache/webbeans/test/xml/specializes/alternatives.xml");
        Assert.assertNotNull((Object)stream);
        WebBeansXMLConfigurator configurator = new WebBeansXMLConfigurator();
        configurator.configureSpecSpecific(stream, "alternative.xml");
        this.defineManagedBean(SystemLogger.class);
        this.defineManagedBean(MockNotSpecializedLogger.class);
        AbstractInjectionTargetBean<SpecializedInjector> bean = this.defineManagedBean(SpecializedInjector.class);
        Object instance = this.getManager().getReference((Bean<?>)bean, (Type)((Object)SpecializedInjector.class), this.getManager().createCreationalContext(bean));
        Assert.assertTrue((boolean)(instance instanceof SpecializedInjector));
        SpecializedInjector injector = (SpecializedInjector)instance;
        ISomeLogger logger = injector.logger();
        Assert.assertTrue((boolean)(logger instanceof SystemLogger));
        logger.printError("Hello World");
        SystemLogger sysLogger = (SystemLogger)logger;
        Assert.assertEquals((String)"Hello World", (String)sysLogger.getMessage());
        PluginLoader.getInstance().shutDown();
        AlternativesManager.getInstance().clear();
    }

    @Test
    public void testSpecializedVersion() {
        this.clear();
        PluginLoader.getInstance().startUp();
        InputStream stream = XMLTest.class.getClassLoader().getResourceAsStream("org/apache/webbeans/test/xml/specializes/alternatives.xml");
        Assert.assertNotNull((Object)stream);
        WebBeansXMLConfigurator configurator = new WebBeansXMLConfigurator();
        configurator.configureSpecSpecific(stream, "alternatives.xml");
        this.defineManagedBean(SystemLogger.class);
        this.defineManagedBean(MockSpecializedLogger.class);
        ArrayList<Class<MockSpecializedLogger>> specialClassList = new ArrayList<Class<MockSpecializedLogger>>();
        specialClassList.add(MockSpecializedLogger.class);
        WebBeansUtil.configureSpecializations(specialClassList);
        AbstractInjectionTargetBean<SpecializedInjector> bean = this.defineManagedBean(SpecializedInjector.class);
        Object instance = this.getManager().getReference((Bean<?>)bean, (Type)((Object)SpecializedInjector.class), this.getManager().createCreationalContext(bean));
        Assert.assertTrue((boolean)(instance instanceof SpecializedInjector));
        SpecializedInjector injector = (SpecializedInjector)instance;
        ISomeLogger logger = injector.logger();
        Assert.assertTrue((boolean)(logger instanceof MockSpecializedLogger));
        logger.printError("Hello World");
        MockSpecializedLogger sysLogger = (MockSpecializedLogger)logger;
        Assert.assertEquals((String)"Hello World", (String)sysLogger.getMessage());
        PluginLoader.getInstance().shutDown();
    }
}

