/*
 * Decompiled with CFR 0.152.
 */
package org.apache.webbeans.test.unittests.producer;

import java.lang.annotation.Annotation;
import java.util.List;
import javax.enterprise.util.TypeLiteral;
import junit.framework.Assert;
import org.apache.webbeans.component.AbstractInjectionTargetBean;
import org.apache.webbeans.context.ContextFactory;
import org.apache.webbeans.test.TestContext;
import org.apache.webbeans.test.component.producer.ParametrizedModel1;
import org.apache.webbeans.test.component.producer.ParametrizedModel2;
import org.apache.webbeans.test.component.producer.ParametrizedProducer;
import org.apache.webbeans.test.component.producer.Producer1;
import org.apache.webbeans.test.component.producer.Producer2;
import org.apache.webbeans.test.component.producer.Producer3;
import org.apache.webbeans.test.component.producer.Producer4;
import org.apache.webbeans.test.component.producer.Producer4ConsumerComponent;
import org.junit.Before;
import org.junit.Test;

public class ProducerComponentTest
extends TestContext {
    public ProducerComponentTest() {
        super(ProducerComponentTest.class.getSimpleName());
    }

    @Override
    @Before
    public void init() {
        super.init();
    }

    @Override
    public void startTests(Object ctx) {
        this.testProducerDeployment1();
        this.testProducerDeployment2();
    }

    @Test
    public void testProducerDeployment1() {
        this.clear();
        this.defineManagedBean(Producer1.class);
        Assert.assertEquals((int)3, (int)this.getDeployedComponents());
    }

    @Test
    public void testProducerDeployment2() {
        this.clear();
        this.defineManagedBean(Producer2.class);
        Assert.assertEquals((int)4, (int)this.getDeployedComponents());
    }

    @Test
    public void testProducerDeployment3() {
        this.clear();
        this.defineManagedBean(Producer3.class);
        Assert.assertEquals((int)6, (int)this.getDeployedComponents());
    }

    @Test
    public void testParametrizedProducer() {
        this.clear();
        this.defineManagedBean(ParametrizedProducer.class);
        ContextFactory.initRequestContext(null);
        Assert.assertEquals((int)4, (int)this.getDeployedComponents());
        TypeLiteral<List<ParametrizedModel1>> model1 = new TypeLiteral<List<ParametrizedModel1>>(){};
        List<ParametrizedModel1> instance = this.getManager().getInstanceByType(model1, new Annotation[0]);
        Assert.assertNull(instance);
        Assert.assertTrue((boolean)ParametrizedProducer.getCALLMODEL1());
        Assert.assertTrue((!ParametrizedProducer.getCALLMODEL2() ? 1 : 0) != 0);
        TypeLiteral<List<ParametrizedModel2>> model2 = new TypeLiteral<List<ParametrizedModel2>>(){};
        List<ParametrizedModel2> instance2 = this.getManager().getInstanceByType(model2, new Annotation[0]);
        Assert.assertNull(instance2);
        Assert.assertTrue((boolean)ParametrizedProducer.getCALLMODEL2());
    }

    @Test
    public void testProducer4() {
        this.defineManagedBean(Producer4.class);
        AbstractInjectionTargetBean<Producer4ConsumerComponent> component = this.defineManagedBean(Producer4ConsumerComponent.class);
        ContextFactory.initSessionContext((Object)new Object());
        Producer4ConsumerComponent instance = this.getManager().getInstance(component);
        Assert.assertNotNull((Object)instance);
        int count = instance.count();
        Assert.assertEquals((int)1, (int)count);
    }
}

