/*
 * Decompiled with CFR 0.152.
 */
package org.apache.webbeans.test.unittests.portable;

import java.lang.annotation.Annotation;
import java.lang.reflect.ParameterizedType;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.enterprise.event.Observes;
import javax.enterprise.inject.Default;
import javax.enterprise.inject.Produces;
import javax.enterprise.inject.spi.AnnotatedConstructor;
import javax.enterprise.inject.spi.AnnotatedField;
import javax.enterprise.inject.spi.AnnotatedMethod;
import javax.enterprise.inject.spi.AnnotatedParameter;
import javax.enterprise.inject.spi.AnnotatedType;
import javax.inject.Inject;
import javax.inject.Named;
import javax.interceptor.Interceptor;
import junit.framework.Assert;
import org.apache.webbeans.portable.AnnotatedElementFactory;
import org.apache.webbeans.test.TestContext;
import org.apache.webbeans.test.annotation.binding.Binding1;
import org.apache.webbeans.test.annotation.binding.Binding2;
import org.apache.webbeans.test.component.CheckWithCheckPayment;
import org.apache.webbeans.test.component.IPayment;
import org.apache.webbeans.test.component.inject.parametrized.Dao;
import org.apache.webbeans.test.component.library.Book;
import org.apache.webbeans.test.component.portable.PortableType1;
import org.apache.webbeans.test.xml.annot.BindingType1;
import org.apache.webbeans.test.xml.annot.BindingType2;
import org.junit.Test;

public class PortableTests
extends TestContext {
    public PortableTests() {
        super(PortableTests.class.getName());
    }

    @Test
    public void testAnnotatedType() {
        AnnotatedType type = AnnotatedElementFactory.getInstance().newAnnotatedType(PortableType1.class);
        Set annotations = type.getAnnotations();
        HashSet<Class<? extends Annotation>> clazzesAnnots = new HashSet<Class<? extends Annotation>>();
        for (Annotation ann : annotations) {
            clazzesAnnots.add(ann.annotationType());
        }
        Assert.assertTrue((boolean)clazzesAnnots.contains(Named.class));
        Assert.assertTrue((boolean)clazzesAnnots.contains(Default.class));
        Assert.assertTrue((boolean)clazzesAnnots.contains(Binding1.class));
        Assert.assertTrue((boolean)clazzesAnnots.contains(Binding2.class));
        Assert.assertTrue((boolean)clazzesAnnots.contains(Interceptor.class));
        Set cs = type.getConstructors();
        Assert.assertEquals((int)1, (int)cs.size());
        AnnotatedConstructor c = (AnnotatedConstructor)cs.iterator().next();
        Assert.assertTrue((boolean)c.isAnnotationPresent(Inject.class));
        Set fields = type.getFields();
        Assert.assertEquals((int)3, (int)fields.size());
        for (AnnotatedField field : fields) {
            if (field.getJavaMember().getName().equals("payment")) {
                Assert.assertTrue((boolean)field.isAnnotationPresent(Default.class));
                Assert.assertEquals(IPayment.class, (Object)field.getBaseType());
                continue;
            }
            if (field.getJavaMember().getName().equals("book")) {
                Assert.assertTrue((boolean)field.isAnnotationPresent(Default.class));
                Assert.assertTrue((boolean)field.isAnnotationPresent(Binding2.class));
                Assert.assertEquals(Book.class, (Object)field.getBaseType());
                continue;
            }
            Assert.assertTrue((boolean)field.isAnnotationPresent(Produces.class));
            Assert.assertTrue((boolean)field.isAnnotationPresent(BindingType2.class));
            Assert.assertEquals(CheckWithCheckPayment.class, (Object)field.getBaseType());
        }
        Set methods = type.getMethods();
        Assert.assertEquals((int)8, (int)methods.size());
        for (AnnotatedMethod method : methods) {
            AnnotatedParameter param;
            List list;
            if (method.getJavaMember().getName().equals("getDao")) {
                Assert.assertTrue((boolean)method.isAnnotationPresent(Produces.class));
                Assert.assertEquals(Dao.class, (Object)((ParameterizedType)method.getBaseType()).getRawType());
                list = method.getParameters();
                Assert.assertTrue((list.size() == 1 ? 1 : 0) != 0);
                param = (AnnotatedParameter)list.iterator().next();
                Assert.assertTrue((param.getAnnotations().size() == 1 ? 1 : 0) != 0);
                Assert.assertTrue((boolean)param.isAnnotationPresent(BindingType1.class));
                continue;
            }
            if (!method.getJavaMember().getName().equals("notify")) continue;
            Assert.assertTrue((boolean)method.getAnnotations().isEmpty());
            Assert.assertEquals(Void.TYPE, (Object)method.getBaseType());
            list = method.getParameters();
            Assert.assertTrue((list.size() == 1 ? 1 : 0) != 0);
            param = (AnnotatedParameter)list.iterator().next();
            Assert.assertTrue((param.getAnnotations().size() == 2 ? 1 : 0) != 0);
            Assert.assertTrue((boolean)param.isAnnotationPresent(Binding2.class));
            Assert.assertTrue((boolean)param.isAnnotationPresent(Observes.class));
        }
    }
}

