/*
 * Decompiled with CFR 0.152.
 */
package org.apache.webbeans.test.unittests.intercept.webbeans;

import java.util.List;
import javax.enterprise.inject.spi.Bean;
import junit.framework.Assert;
import org.apache.webbeans.component.AbstractOwbBean;
import org.apache.webbeans.context.ContextFactory;
import org.apache.webbeans.exception.WebBeansConfigurationException;
import org.apache.webbeans.test.TestContext;
import org.apache.webbeans.test.component.intercept.webbeans.WInterceptorComponent;
import org.apache.webbeans.test.component.intercept.webbeans.WMetaInterceptorComponent;
import org.apache.webbeans.test.component.intercept.webbeans.WebBeansInterceptor;
import org.apache.webbeans.test.component.intercept.webbeans.WebBeanswithMetaInterceptor;
import org.junit.Before;
import org.junit.Test;

public class WebBeansInterceptComponentTest
extends TestContext {
    boolean init = false;

    public WebBeansInterceptComponentTest() {
        super(WebBeansInterceptComponentTest.class.getName());
    }

    @Override
    @Before
    public void init() {
        super.init();
        this.initializeInterceptorType(WebBeansInterceptor.class);
        this.initializeInterceptorType(WebBeanswithMetaInterceptor.class);
    }

    @Test
    public void testInterceptedComponent() {
        WebBeansConfigurationException exc = null;
        try {
            this.defineInterceptor(WebBeansInterceptor.class);
            this.defineManagedBean(WInterceptorComponent.class);
        }
        catch (WebBeansConfigurationException e) {
            System.out.println(e.getMessage());
            exc = e;
        }
        Assert.assertNull((Object)((Object)exc));
    }

    @Test
    public void testInterceptorCalls() {
        this.getComponents().clear();
        this.defineInterceptor(WebBeansInterceptor.class);
        this.defineManagedBean(WInterceptorComponent.class);
        ContextFactory.initRequestContext(null);
        List<AbstractOwbBean<?>> comps = this.getComponents();
        Object object = this.getManager().getInstance((Bean)comps.get(0));
        Assert.assertTrue((boolean)(object instanceof WInterceptorComponent));
        WInterceptorComponent comp = (WInterceptorComponent)object;
        int s = comp.hello();
        Assert.assertEquals((int)5, (int)s);
        ContextFactory.destroyRequestContext(null);
    }

    @Test
    public void testMetaInterceptorCalls() {
        this.getComponents().clear();
        this.defineInterceptor(WebBeansInterceptor.class);
        this.defineInterceptor(WebBeanswithMetaInterceptor.class);
        this.defineManagedBean(WMetaInterceptorComponent.class);
        ContextFactory.initRequestContext(null);
        List<AbstractOwbBean<?>> comps = this.getComponents();
        Object object = this.getManager().getInstance((Bean)comps.get(0));
        Assert.assertTrue((boolean)(object instanceof WMetaInterceptorComponent));
        WMetaInterceptorComponent comp = (WMetaInterceptorComponent)object;
        int s = comp.hello();
        Assert.assertEquals((int)5, (int)s);
        s = comp.hello2();
        Assert.assertEquals((int)10, (int)s);
        ContextFactory.destroyRequestContext(null);
    }
}

