/*
 * Decompiled with CFR 0.152.
 */
package org.apache.webbeans.test.unittests.intercept;

import java.util.List;
import javax.enterprise.inject.spi.Bean;
import junit.framework.Assert;
import org.apache.webbeans.component.AbstractOwbBean;
import org.apache.webbeans.context.ContextFactory;
import org.apache.webbeans.test.TestContext;
import org.apache.webbeans.test.component.intercept.InterceptedComponent;
import org.apache.webbeans.test.component.intercept.InterceptorWithSuperClassInterceptedComponent;
import org.apache.webbeans.test.component.intercept.MultipleInterceptedComponent;
import org.apache.webbeans.test.component.intercept.MultipleListOfInterceptedComponent;
import org.apache.webbeans.test.component.intercept.MultipleListOfInterceptedWithExcludeClassComponent;
import org.junit.Before;
import org.junit.Test;

public class EJBInterceptComponentTest
extends TestContext {
    public EJBInterceptComponentTest() {
        super(EJBInterceptComponentTest.class.getName());
    }

    @Override
    @Before
    public void init() {
        super.init();
    }

    @Test
    public void testInterceptedComponent() {
        this.defineManagedBean(InterceptedComponent.class);
    }

    @Test
    public void testInterceptorCalls() {
        this.clear();
        this.defineManagedBean(InterceptedComponent.class);
        ContextFactory.initRequestContext(null);
        List<AbstractOwbBean<?>> comps = this.getComponents();
        Object object = this.getManager().getInstance((Bean)comps.get(0));
        Assert.assertTrue((boolean)(object instanceof InterceptedComponent));
        InterceptedComponent comp = (InterceptedComponent)object;
        Object s = comp.hello(null);
        Assert.assertEquals((Object)new Integer(5), (Object)s);
        ContextFactory.destroyRequestContext(null);
    }

    @Test
    public void testMultipleInterceptedComponent() {
        this.clear();
        this.defineManagedBean(MultipleInterceptedComponent.class);
        ContextFactory.initRequestContext(null);
        List<AbstractOwbBean<?>> comps = this.getComponents();
        Object object = this.getManager().getInstance((Bean)comps.get(0));
        Assert.assertTrue((boolean)(object instanceof MultipleInterceptedComponent));
        MultipleInterceptedComponent comp = (MultipleInterceptedComponent)object;
        Object obj = comp.intercepted();
        Assert.assertTrue((boolean)(obj instanceof String[]));
        String[] arr = (String[])obj;
        Assert.assertEquals((int)2, (int)arr.length);
        Assert.assertTrue(("key".equals(arr[0]) && "key2".equals(arr[1]) || "key".equals(arr[1]) && "key2".equals(arr[0]) ? 1 : 0) != 0);
        ContextFactory.destroyRequestContext(null);
    }

    @Test
    public void testInterceptorWithSuperClassComponent() {
        this.clear();
        this.defineManagedBean(InterceptorWithSuperClassInterceptedComponent.class);
        ContextFactory.initRequestContext(null);
        List<AbstractOwbBean<?>> comps = this.getComponents();
        Object object = this.getManager().getInstance((Bean)comps.get(0));
        Assert.assertTrue((boolean)(object instanceof InterceptorWithSuperClassInterceptedComponent));
        InterceptorWithSuperClassInterceptedComponent comp = (InterceptorWithSuperClassInterceptedComponent)object;
        Object obj = comp.intercepted();
        Assert.assertTrue((boolean)(obj instanceof String[]));
        String[] arr = (String[])obj;
        Assert.assertEquals((int)2, (int)arr.length);
        Assert.assertTrue(("key".equals(arr[0]) && "key0".equals(arr[1]) || "key".equals(arr[1]) && "key0".equals(arr[0]) ? 1 : 0) != 0);
        ContextFactory.destroyRequestContext(null);
    }

    @Test
    public void testMultipleListOfInterceptedComponent() {
        this.clear();
        this.defineManagedBean(MultipleListOfInterceptedComponent.class);
        ContextFactory.initRequestContext(null);
        List<AbstractOwbBean<?>> comps = this.getComponents();
        Object object = this.getManager().getInstance((Bean)comps.get(0));
        Assert.assertTrue((boolean)(object instanceof MultipleListOfInterceptedComponent));
        MultipleListOfInterceptedComponent comp = (MultipleListOfInterceptedComponent)object;
        Object obj = comp.intercepted();
        Assert.assertTrue((boolean)(obj instanceof String));
        Assert.assertEquals((String)"ok", (String)((String)obj));
        ContextFactory.destroyRequestContext(null);
    }

    @Test
    public void testMultipleListOfInterceptedWithExcludeClassComponent() {
        this.clear();
        this.defineManagedBean(MultipleListOfInterceptedWithExcludeClassComponent.class);
        ContextFactory.initRequestContext(null);
        List<AbstractOwbBean<?>> comps = this.getComponents();
        Object object = this.getManager().getInstance((Bean)comps.get(0));
        Assert.assertTrue((boolean)(object instanceof MultipleListOfInterceptedWithExcludeClassComponent));
        MultipleListOfInterceptedWithExcludeClassComponent comp = (MultipleListOfInterceptedWithExcludeClassComponent)object;
        Object obj = comp.intercepted();
        Assert.assertTrue((boolean)(obj instanceof String));
        Assert.assertEquals((String)"value2", (String)((String)obj));
        ContextFactory.destroyRequestContext(null);
    }
}

