/*
 * Decompiled with CFR 0.152.
 */
package org.apache.webbeans.test.unittests.inject.named;

import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.util.Set;
import javax.enterprise.inject.spi.InjectionPoint;
import javax.inject.Named;
import org.apache.webbeans.component.AbstractInjectionTargetBean;
import org.apache.webbeans.exception.WebBeansConfigurationException;
import org.apache.webbeans.inject.impl.InjectionPointFactory;
import org.apache.webbeans.test.TestContext;
import org.apache.webbeans.test.component.IPayment;
import org.apache.webbeans.test.component.inject.named.NamedFieldWithNamedValue;
import org.apache.webbeans.test.component.inject.named.NamedFieldWithoutNamedValue;
import org.apache.webbeans.test.component.inject.named.NamedOtherWithNamedValue;
import org.apache.webbeans.test.component.inject.named.NamedOtherWithoutNamedValue;
import org.apache.webbeans.util.WebBeansUtil;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class NamedTests
extends TestContext {
    public NamedTests() {
        super(NamedTests.class.getName());
    }

    @Override
    @Before
    public void init() {
        super.init();
    }

    @Test
    public void testFieldWithNamedValue() throws Exception {
        AbstractInjectionTargetBean<NamedFieldWithNamedValue> bean = this.defineManagedBean(NamedFieldWithNamedValue.class);
        Field field = NamedFieldWithNamedValue.class.getDeclaredField("paymentProcessor");
        InjectionPoint point = InjectionPointFactory.getFieldInjectionPointData(bean, (Field)field);
        WebBeansUtil.checkInjectionPointNamedQualifier((InjectionPoint)point);
        String value = this.qulifier(point);
        Assert.assertEquals((Object)"payment", (Object)value);
    }

    @Test
    public void testFieldWithoutNamedValue() throws Exception {
        AbstractInjectionTargetBean<NamedFieldWithoutNamedValue> bean = this.defineManagedBean(NamedFieldWithoutNamedValue.class);
        Field field = NamedFieldWithoutNamedValue.class.getDeclaredField("paymentProcessor");
        InjectionPoint point = InjectionPointFactory.getFieldInjectionPointData(bean, (Field)field);
        WebBeansUtil.checkInjectionPointNamedQualifier((InjectionPoint)point);
        String value = this.qulifier(point);
        Assert.assertEquals((Object)"paymentProcessor", (Object)value);
    }

    @Test
    public void testOtherWithNamedValue() throws Exception {
        AbstractInjectionTargetBean<NamedOtherWithNamedValue> bean = this.defineManagedBean(NamedOtherWithNamedValue.class);
        Constructor constructor = NamedOtherWithNamedValue.class.getDeclaredConstructor(IPayment.class);
        InjectionPoint point = (InjectionPoint)InjectionPointFactory.getConstructorInjectionPointData(bean, constructor).get(0);
        WebBeansUtil.checkInjectionPointNamedQualifier((InjectionPoint)point);
        String value = this.qulifier(point);
        Assert.assertEquals((Object)"value", (Object)value);
    }

    @Test(expected=WebBeansConfigurationException.class)
    public void testOtherWithoutNamedValue() throws Exception {
        AbstractInjectionTargetBean<NamedOtherWithoutNamedValue> bean = this.defineManagedBean(NamedOtherWithoutNamedValue.class);
        Constructor constructor = NamedOtherWithoutNamedValue.class.getDeclaredConstructor(IPayment.class);
        InjectionPoint point = (InjectionPoint)InjectionPointFactory.getConstructorInjectionPointData(bean, constructor).get(0);
        String value = this.qulifier(point);
        Assert.assertEquals((Object)"", (Object)value);
        WebBeansUtil.checkInjectionPointNamedQualifier((InjectionPoint)point);
    }

    private String qulifier(InjectionPoint injectionPoint) {
        Set qualifierset = injectionPoint.getQualifiers();
        Named namedQualifier = null;
        for (Annotation qualifier : qualifierset) {
            if (!qualifier.annotationType().equals(Named.class)) continue;
            namedQualifier = (Named)qualifier;
            break;
        }
        if (namedQualifier != null) {
            return namedQualifier.value();
        }
        return null;
    }
}

