/*
 * Decompiled with CFR 0.152.
 */
package org.apache.webbeans.test.unittests.inject.alternative;

import java.io.InputStream;
import java.lang.reflect.Type;
import javax.enterprise.inject.spi.Bean;
import junit.framework.Assert;
import org.apache.webbeans.component.AbstractInjectionTargetBean;
import org.apache.webbeans.inject.AlternativesManager;
import org.apache.webbeans.plugins.PluginLoader;
import org.apache.webbeans.test.TestContext;
import org.apache.webbeans.test.component.inject.alternative.AlternativeComponent;
import org.apache.webbeans.test.component.inject.alternative.AlternativeInjector;
import org.apache.webbeans.test.component.inject.alternative.IAlternative;
import org.apache.webbeans.test.component.inject.alternative.NotAlternativeComponent;
import org.apache.webbeans.test.unittests.xml.XMLTest;
import org.apache.webbeans.xml.WebBeansXMLConfigurator;
import org.junit.Before;
import org.junit.Test;

public class AlternativeTest
extends TestContext {
    public AlternativeTest() {
        super(AlternativeTest.class.getName());
    }

    @Before
    public void setUp() {
        super.init();
    }

    @Test
    public void testInjectAlternative() {
        InputStream stream = XMLTest.class.getClassLoader().getResourceAsStream("org/apache/webbeans/test/xml/alternative/alternatives.xml");
        Assert.assertNotNull((Object)stream);
        WebBeansXMLConfigurator configurator = new WebBeansXMLConfigurator();
        configurator.configureSpecSpecific(stream, "alternative.xml");
        this.defineManagedBean(AlternativeComponent.class);
        this.defineManagedBean(NotAlternativeComponent.class);
        AbstractInjectionTargetBean<AlternativeInjector> injector = this.defineManagedBean(AlternativeInjector.class);
        AlternativeInjector instance = (AlternativeInjector)this.getManager().getReference((Bean<?>)injector, (Type)((Object)AlternativeInjector.class), this.getManager().createCreationalContext(injector));
        Assert.assertNotNull((Object)instance);
        IAlternative alternative = instance.getAlternative();
        Assert.assertTrue((boolean)(alternative instanceof AlternativeComponent));
        PluginLoader.getInstance().shutDown();
    }

    @Test
    public void testInjectNotAlternative() {
        AlternativesManager.getInstance().clear();
        this.defineManagedBean(AlternativeComponent.class);
        this.defineManagedBean(NotAlternativeComponent.class);
        AbstractInjectionTargetBean<AlternativeInjector> injector = this.defineManagedBean(AlternativeInjector.class);
        AlternativeInjector instance = (AlternativeInjector)this.getManager().getReference((Bean<?>)injector, (Type)((Object)AlternativeInjector.class), this.getManager().createCreationalContext(injector));
        Assert.assertNotNull((Object)instance);
        IAlternative alternative = instance.getAlternative();
        Assert.assertTrue((boolean)(alternative instanceof NotAlternativeComponent));
        PluginLoader.getInstance().shutDown();
    }
}

