/*
 * Decompiled with CFR 0.152.
 */
package org.apache.webbeans.test.unittests.inject;

import java.util.List;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.BeanManager;
import junit.framework.Assert;
import org.apache.webbeans.component.AbstractOwbBean;
import org.apache.webbeans.container.BeanManagerImpl;
import org.apache.webbeans.context.ContextFactory;
import org.apache.webbeans.test.TestContext;
import org.apache.webbeans.test.component.service.ITyped2;
import org.apache.webbeans.test.component.service.Typed2;
import org.apache.webbeans.test.component.service.TypedInjection;
import org.apache.webbeans.test.component.service.TypedInjectionWithoutArguments;
import org.junit.Before;
import org.junit.Test;

public class TypedInjectedComponentTest
extends TestContext {
    BeanManager container = null;

    public TypedInjectedComponentTest() {
        super(TypedInjectedComponentTest.class.getSimpleName());
    }

    @Override
    @Before
    public void init() {
        super.init();
        this.container = BeanManagerImpl.getManager();
    }

    @Test
    public void testTypedComponent() throws Throwable {
        this.clear();
        this.defineManagedBean(Typed2.class);
        this.defineManagedBean(TypedInjection.class);
        List<AbstractOwbBean<?>> comps = this.getComponents();
        Object session = this.getSession();
        ContextFactory.initSessionContext((Object)session);
        Assert.assertEquals((int)2, (int)comps.size());
        this.getManager().getInstance((Bean)comps.get(0));
        Object object = this.getManager().getInstance((Bean)comps.get(1));
        Assert.assertTrue((boolean)(object instanceof TypedInjection));
        TypedInjection i = (TypedInjection)object;
        Typed2 typed2 = (Typed2)i.getV();
        typed2.setValue(true);
        Assert.assertTrue((boolean)(i.getV() instanceof ITyped2));
        Typed2 obj2 = (Typed2)this.getManager().getInstance((Bean)comps.get(0));
        Assert.assertSame((Object)typed2.isValue(), (Object)obj2.isValue());
        ContextFactory.destroySessionContext((Object)session);
    }

    @Test
    public void testTypedComponentWithoutArgument() throws Throwable {
        this.clear();
        this.defineManagedBean(Typed2.class);
        this.defineManagedBean(TypedInjectionWithoutArguments.class);
        List<AbstractOwbBean<?>> comps = this.getComponents();
        Object session = this.getSession();
        ContextFactory.initSessionContext((Object)session);
        Assert.assertEquals((int)2, (int)comps.size());
        this.getManager().getInstance((Bean)comps.get(0));
        Object object = this.getManager().getInstance((Bean)comps.get(1));
        Assert.assertTrue((boolean)(object instanceof TypedInjectionWithoutArguments));
        TypedInjectionWithoutArguments i = (TypedInjectionWithoutArguments)object;
        Typed2 typed2 = (Typed2)i.getV();
        typed2.setValue(true);
        Assert.assertTrue((boolean)(i.getV() instanceof ITyped2));
        Typed2 obj2 = (Typed2)this.getManager().getInstance((Bean)comps.get(0));
        Assert.assertSame((Object)typed2.isValue(), (Object)obj2.isValue());
        ContextFactory.destroySessionContext((Object)session);
    }
}

