/*
 * Decompiled with CFR 0.152.
 */
package org.apache.webbeans.test.unittests.exception;

import javax.enterprise.context.Dependent;
import javax.enterprise.context.RequestScoped;
import javax.enterprise.context.SessionScoped;
import javax.enterprise.inject.spi.Bean;
import junit.framework.Assert;
import org.apache.webbeans.exception.WebBeansConfigurationException;
import org.apache.webbeans.test.TestContext;
import org.apache.webbeans.test.component.exception.stero.ComponentDefaultScopeWithDifferentScopeSteros;
import org.apache.webbeans.test.component.exception.stero.ComponentDefaultScopeWithNonScopeStero;
import org.apache.webbeans.test.component.exception.stero.ComponentNonDefaultScopeWithDifferentScopeSteros;
import org.apache.webbeans.test.component.exception.stero.ComponentWithDefaultScopeStero;
import org.apache.webbeans.test.component.exception.stero.ComponentWithDifferentScopeSteros;
import org.apache.webbeans.test.component.exception.stero.ComponentWithNonScopeStero;
import org.apache.webbeans.test.component.exception.stero.ComponentWithSameScopeSteros;
import org.apache.webbeans.test.component.exception.stero.ComponentWithoutScopeStero;
import org.junit.Before;
import org.junit.Test;

public class ScopeTypeExceptionComponentTest
extends TestContext {
    public ScopeTypeExceptionComponentTest() {
        super(ScopeTypeExceptionComponentTest.class.getName());
    }

    @Override
    @Before
    public void init() {
        super.init();
    }

    @Test
    public void testComponentWithNonScopeStero() {
        this.clear();
        this.defineManagedBean(ComponentWithNonScopeStero.class);
        Bean bean = (Bean)this.getComponents().get(0);
        Assert.assertEquals(Dependent.class, (Object)bean.getScope());
    }

    @Test
    public void testComponentDefaultScopeWithNonScopeStero() {
        this.clear();
        this.defineManagedBean(ComponentDefaultScopeWithNonScopeStero.class);
        Bean bean = (Bean)this.getComponents().get(0);
        Assert.assertEquals(SessionScoped.class, (Object)bean.getScope());
    }

    @Test
    public void testComponentWithDefaultScopeStero() {
        this.clear();
        this.defineManagedBean(ComponentWithDefaultScopeStero.class);
        Bean bean = (Bean)this.getComponents().get(0);
        Assert.assertEquals(RequestScoped.class, (Object)bean.getScope());
    }

    @Test
    public void testComponentWithDifferentScopeSteros() {
        this.clear();
        try {
            this.defineManagedBean(ComponentWithDifferentScopeSteros.class);
        }
        catch (WebBeansConfigurationException e) {
            System.out.println("got expected exception: " + e.getMessage());
            return;
        }
        Assert.fail((String)"expecting an exception!");
    }

    @Test
    public void testComponentWithoutScopeStero() {
        this.clear();
        this.defineManagedBean(ComponentWithoutScopeStero.class);
        Bean bean = (Bean)this.getComponents().get(0);
        Assert.assertEquals(Dependent.class, (Object)bean.getScope());
    }

    @Test
    public void testComponentWithSameScopeSteros() {
        this.clear();
        this.defineManagedBean(ComponentWithSameScopeSteros.class);
        Bean bean = (Bean)this.getComponents().get(0);
        Assert.assertEquals(SessionScoped.class, (Object)bean.getScope());
    }

    @Test
    public void testComponentDefaultScopeWithDifferentScopeSteros() {
        this.clear();
        this.defineManagedBean(ComponentDefaultScopeWithDifferentScopeSteros.class);
        Bean bean = (Bean)this.getComponents().get(0);
        Assert.assertEquals(SessionScoped.class, (Object)bean.getScope());
    }

    @Test
    public void testComponentNonDefaultScopeWithDifferentScopeSteros() {
        this.clear();
        try {
            this.defineManagedBean(ComponentNonDefaultScopeWithDifferentScopeSteros.class);
        }
        catch (WebBeansConfigurationException e) {
            System.out.println("got expected exception: " + e.getMessage());
            return;
        }
        Assert.fail((String)"expecting an exception!");
    }
}

