/*
 * Decompiled with CFR 0.152.
 */
package org.apache.webbeans.test.unittests.exception;

import java.util.List;
import javax.enterprise.inject.spi.Bean;
import junit.framework.Assert;
import org.apache.webbeans.component.AbstractInjectionTargetBean;
import org.apache.webbeans.component.AbstractOwbBean;
import org.apache.webbeans.exception.WebBeansConfigurationException;
import org.apache.webbeans.intercept.ejb.EJBInterceptorConfig;
import org.apache.webbeans.test.TestContext;
import org.apache.webbeans.test.component.exception.AroundInvokeWithFinalMethodComponent;
import org.apache.webbeans.test.component.exception.AroundInvokeWithSameMethodNameComponent;
import org.apache.webbeans.test.component.exception.AroundInvokeWithStaticMethodComponent;
import org.apache.webbeans.test.component.exception.AroundInvokeWithWrongReturnTypeComponent;
import org.apache.webbeans.test.component.exception.AroundInvokeWithoutExceptionComponent;
import org.apache.webbeans.test.component.exception.AroundInvokeWithoutParameterComponent;
import org.apache.webbeans.test.component.exception.AroundInvokeWithoutReturnTypeComponent;
import org.apache.webbeans.test.component.exception.FinalComponent;
import org.apache.webbeans.test.component.exception.HasFinalMethodComponent;
import org.apache.webbeans.test.component.exception.InnerComponent;
import org.apache.webbeans.test.component.exception.MoreThanOneAroundInvokeComponent;
import org.apache.webbeans.test.component.exception.MoreThanOneConstructureComponent;
import org.apache.webbeans.test.component.exception.MoreThanOneConstructureComponent2;
import org.apache.webbeans.test.component.exception.MoreThanOnePostConstructComponent;
import org.apache.webbeans.test.component.exception.MultipleDisposalMethodComponent;
import org.apache.webbeans.test.component.exception.NewComponentBindingComponent;
import org.apache.webbeans.test.component.exception.NoConstructureComponent;
import org.apache.webbeans.test.component.exception.PostContructMethodHasCheckedExceptionComponent;
import org.apache.webbeans.test.component.exception.PostContructMethodHasParameterComponent;
import org.apache.webbeans.test.component.exception.PostContructMethodHasReturnTypeComponent;
import org.apache.webbeans.test.component.exception.PostContructMethodHasStaticComponent;
import org.apache.webbeans.test.component.exception.ProducerTypeStaticComponent;
import org.apache.webbeans.test.component.intercept.NoArgConstructorInterceptorComponent;
import org.junit.Before;
import org.junit.Test;

public class ExceptionComponentTest
extends TestContext {
    public ExceptionComponentTest() {
        super(ExceptionComponentTest.class.getName());
    }

    @Override
    @Before
    public void init() {
        super.init();
    }

    @Test
    public void testFinal() {
        this.clear();
        this.defineManagedBean(FinalComponent.class);
    }

    @Test
    public void testAbstract() {
        try {
            this.clear();
            this.defineManagedBean(AbstractOwbBean.class);
        }
        catch (WebBeansConfigurationException e) {
            System.out.println("got expected exception: " + e.getMessage());
            return;
        }
        Assert.fail((String)"expecting an exception!");
    }

    @Test
    public void testInner() {
        try {
            this.clear();
            this.defineManagedBean(InnerComponent.InnerInnerComponent.class);
        }
        catch (WebBeansConfigurationException e) {
            System.out.println("got expected exception: " + e.getMessage());
            return;
        }
        Assert.fail((String)"expecting an exception!");
    }

    @Test
    public void testHasFinalMethod() {
        try {
            this.clear();
            this.defineManagedBean(HasFinalMethodComponent.class);
        }
        catch (WebBeansConfigurationException e) {
            System.out.println("got expected exception: " + e.getMessage());
            return;
        }
        Assert.fail((String)"expecting an exception!");
    }

    @Test
    public void constructorTest() {
        try {
            this.clear();
            this.defineManagedBean(MoreThanOneConstructureComponent.class);
            Assert.fail((String)"expecting an exception!");
        }
        catch (WebBeansConfigurationException e) {
            System.out.println("got expected exception: " + e.getMessage());
        }
        try {
            this.clear();
            this.defineManagedBean(MoreThanOneConstructureComponent2.class);
        }
        catch (WebBeansConfigurationException e) {
            System.out.println("got expected exception: " + e.getMessage());
        }
        this.clear();
        this.defineManagedBean(NoConstructureComponent.class);
    }

    @Test
    public void testStaticProducerMethod() {
        this.clear();
        this.defineManagedBean(ProducerTypeStaticComponent.class);
    }

    @Test
    public void testDisposeMethod() {
        try {
            this.clear();
            this.defineManagedBean(MultipleDisposalMethodComponent.class);
        }
        catch (WebBeansConfigurationException e) {
            System.out.println("got expected exception: " + e.getMessage());
            return;
        }
        Assert.fail((String)"expecting an exception!");
    }

    @Test
    public void testNewInterface() {
        Assert.assertTrue((boolean)true);
    }

    @Test
    public void testNewBinding() {
        try {
            this.clear();
            this.defineManagedBean(NewComponentBindingComponent.class);
        }
        catch (WebBeansConfigurationException e) {
            System.out.println("got expected exception: " + e.getMessage());
            return;
        }
        Assert.fail((String)"expecting an exception!");
    }

    @Test
    public void testNewMethod() {
        Assert.assertTrue((boolean)true);
    }

    @Test
    public void testMoreThanOnePostConstruct() {
        try {
            this.clear();
            AbstractInjectionTargetBean<MoreThanOnePostConstructComponent> component = this.defineManagedBean(MoreThanOnePostConstructComponent.class);
            EJBInterceptorConfig.configure((Class)component.getReturnType(), (List)component.getInterceptorStack());
        }
        catch (WebBeansConfigurationException e) {
            System.out.println("got expected exception: " + e.getMessage());
            return;
        }
        Assert.fail((String)"expecting an exception!");
    }

    @Test
    public void testPostConstructHasParameter() {
        try {
            this.clear();
            AbstractInjectionTargetBean<PostContructMethodHasParameterComponent> component = this.defineManagedBean(PostContructMethodHasParameterComponent.class);
            EJBInterceptorConfig.configure((Class)component.getReturnType(), (List)component.getInterceptorStack());
        }
        catch (WebBeansConfigurationException e) {
            System.out.println("got expected exception: " + e.getMessage());
            return;
        }
        Assert.fail((String)"expecting an exception!");
    }

    @Test
    public void testPostConstructHasReturnType() {
        try {
            this.clear();
            AbstractInjectionTargetBean<PostContructMethodHasReturnTypeComponent> component = this.defineManagedBean(PostContructMethodHasReturnTypeComponent.class);
            EJBInterceptorConfig.configure((Class)component.getReturnType(), (List)component.getInterceptorStack());
        }
        catch (WebBeansConfigurationException e) {
            System.out.println("got expected exception: " + e.getMessage());
            return;
        }
        Assert.fail((String)"expecting an exception!");
    }

    @Test
    public void testPostConstructHasCheckedException() {
        try {
            this.clear();
            AbstractInjectionTargetBean<PostContructMethodHasCheckedExceptionComponent> component = this.defineManagedBean(PostContructMethodHasCheckedExceptionComponent.class);
            EJBInterceptorConfig.configure((Class)component.getReturnType(), (List)component.getInterceptorStack());
        }
        catch (WebBeansConfigurationException e) {
            System.out.println("got expected exception: " + e.getMessage());
            return;
        }
        Assert.fail((String)"expecting an exception!");
    }

    @Test
    public void testPostConstructHasStatic() {
        try {
            this.clear();
            AbstractInjectionTargetBean<PostContructMethodHasStaticComponent> component = this.defineManagedBean(PostContructMethodHasStaticComponent.class);
            EJBInterceptorConfig.configure((Class)component.getReturnType(), (List)component.getInterceptorStack());
        }
        catch (WebBeansConfigurationException e) {
            System.out.println("got expected exception: " + e.getMessage());
            return;
        }
        Assert.fail((String)"expecting an exception!");
    }

    @Test
    public void testMoreThanOneAroundInvoke() {
        try {
            this.clear();
            AbstractInjectionTargetBean<MoreThanOneAroundInvokeComponent> component = this.defineManagedBean(MoreThanOneAroundInvokeComponent.class);
            EJBInterceptorConfig.configure((Class)component.getReturnType(), (List)component.getInterceptorStack());
        }
        catch (WebBeansConfigurationException e) {
            System.out.println("got expected exception: " + e.getMessage());
            return;
        }
        Assert.fail((String)"expecting an exception!");
    }

    @Test
    public void testAroundInvokeWithSameMethodName() {
        this.clear();
        this.defineManagedBean(AroundInvokeWithSameMethodNameComponent.class);
        Bean comp = (Bean)this.getComponents().get(0);
        Assert.assertEquals((int)0, (int)((AbstractInjectionTargetBean)comp).getInterceptorStack().size());
    }

    @Test
    public void testAroundInvokeWithoutParameter() {
        try {
            this.clear();
            AbstractInjectionTargetBean<AroundInvokeWithoutParameterComponent> component = this.defineManagedBean(AroundInvokeWithoutParameterComponent.class);
            EJBInterceptorConfig.configure((Class)component.getReturnType(), (List)component.getInterceptorStack());
        }
        catch (WebBeansConfigurationException e) {
            System.out.println("got expected exception: " + e.getMessage());
            return;
        }
        Assert.fail((String)"expecting an exception!");
    }

    @Test
    public void testAroundInvokeWithoutReturnType() {
        try {
            this.clear();
            AbstractInjectionTargetBean<AroundInvokeWithoutReturnTypeComponent> component = this.defineManagedBean(AroundInvokeWithoutReturnTypeComponent.class);
            EJBInterceptorConfig.configure((Class)component.getReturnType(), (List)component.getInterceptorStack());
        }
        catch (WebBeansConfigurationException e) {
            System.out.println("got expected exception: " + e.getMessage());
            return;
        }
        Assert.fail((String)"expecting an exception!");
    }

    @Test
    public void testAroundInvokeWithWrongReturnType() {
        try {
            this.clear();
            AbstractInjectionTargetBean<AroundInvokeWithWrongReturnTypeComponent> component = this.defineManagedBean(AroundInvokeWithWrongReturnTypeComponent.class);
            EJBInterceptorConfig.configure((Class)component.getReturnType(), (List)component.getInterceptorStack());
        }
        catch (WebBeansConfigurationException e) {
            System.out.println("got expected exception: " + e.getMessage());
            return;
        }
        Assert.fail((String)"expecting an exception!");
    }

    @Test
    public void testAroundInvokeWithoutException() {
        try {
            this.clear();
            AbstractInjectionTargetBean<AroundInvokeWithoutExceptionComponent> component = this.defineManagedBean(AroundInvokeWithoutExceptionComponent.class);
            EJBInterceptorConfig.configure((Class)component.getReturnType(), (List)component.getInterceptorStack());
        }
        catch (WebBeansConfigurationException e) {
            System.out.println("got expected exception: " + e.getMessage());
            return;
        }
        Assert.fail((String)"expecting an exception!");
    }

    @Test
    public void testAroundInvokeWithStatic() {
        try {
            this.clear();
            AbstractInjectionTargetBean<AroundInvokeWithStaticMethodComponent> component = this.defineManagedBean(AroundInvokeWithStaticMethodComponent.class);
            EJBInterceptorConfig.configure((Class)component.getReturnType(), (List)component.getInterceptorStack());
        }
        catch (WebBeansConfigurationException e) {
            System.out.println("got expected exception: " + e.getMessage());
            return;
        }
        Assert.fail((String)"expecting an exception!");
    }

    @Test
    public void testAroundInvokeWithFinal() {
        try {
            this.clear();
            AbstractInjectionTargetBean<AroundInvokeWithFinalMethodComponent> component = this.defineManagedBean(AroundInvokeWithFinalMethodComponent.class);
            EJBInterceptorConfig.configure((Class)component.getReturnType(), (List)component.getInterceptorStack());
        }
        catch (WebBeansConfigurationException e) {
            System.out.println("got expected exception: " + e.getMessage());
            return;
        }
        Assert.fail((String)"expecting an exception!");
    }

    @Test
    public void testNoArgConstructorInterceptor() {
        try {
            this.clear();
            AbstractInjectionTargetBean<NoArgConstructorInterceptorComponent> component = this.defineManagedBean(NoArgConstructorInterceptorComponent.class);
            EJBInterceptorConfig.configure((Class)component.getReturnType(), (List)component.getInterceptorStack());
        }
        catch (WebBeansConfigurationException e) {
            System.out.println("got expected exception: " + e.getMessage());
            return;
        }
        Assert.fail((String)"expecting an exception!");
    }
}

