/*
 * Decompiled with CFR 0.152.
 */
package org.apache.webbeans.test.unittests.event.exception;

import java.lang.annotation.Annotation;
import javax.enterprise.context.NormalScope;
import javax.enterprise.inject.spi.ObserverMethod;
import javax.enterprise.util.AnnotationLiteral;
import org.apache.webbeans.event.NotificationManager;
import org.apache.webbeans.test.TestContext;
import org.apache.webbeans.test.annotation.binding.Binding1;
import org.apache.webbeans.test.event.LoggedInEvent;
import org.apache.webbeans.test.event.LoggedInObserver;
import org.apache.webbeans.test.event.broke.BrokenEvent;
import org.apache.webbeans.util.ArrayUtil;
import org.junit.Assert;
import org.junit.Test;

public class EventExceptionTest
extends TestContext {
    public EventExceptionTest() {
        super(EventExceptionTest.class.getName());
    }

    @Test
    public void testAddObserverGenericType() {
        Exception exc = null;
        try {
            Annotation[] anns = new Annotation[]{new AnnotationLiteral<Binding1>(){}};
            this.getManager().fireEvent(new BrokenEvent(), anns);
        }
        catch (Exception e) {
            System.out.println(e.getMessage());
            exc = e;
        }
        Assert.assertNotNull((Object)exc);
    }

    @Test
    public void testFireEventGenericType() {
        Object exc = null;
        try {
            Annotation[] anns = new Annotation[]{new AnnotationLiteral<Binding1>(){}};
            this.getManager().fireEvent(new BrokenEvent(), anns);
            Assert.fail();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Test
    public void testAddObserverDuplicateBinding() {
        Exception exc = null;
        try {
            Object[] anns = new Annotation[]{new AnnotationLiteral<Binding1>(){}, new AnnotationLiteral<Binding1>(){}};
            LoggedInObserver observer = new LoggedInObserver(ArrayUtil.asSet((Object[])anns));
            NotificationManager.getInstance().addObserver((ObserverMethod)observer, LoggedInEvent.class);
            this.getManager().fireEvent(new LoggedInEvent(), (Annotation[])anns);
            Assert.assertEquals((Object)"ok", (Object)observer.getResult());
        }
        catch (Exception e) {
            System.out.println(e.getMessage());
            exc = e;
        }
        Assert.assertNotNull((Object)exc);
    }

    @Test
    public void testAddObserverIllegalArgument() {
        Exception exc = null;
        try {
            Object[] anns = new Annotation[2];
            anns[0] = new AnnotationLiteral<NormalScope>(){};
            LoggedInObserver observer = new LoggedInObserver(ArrayUtil.asSet((Object[])anns));
            NotificationManager.getInstance().addObserver((ObserverMethod)observer, LoggedInEvent.class);
            this.getManager().fireEvent(new LoggedInEvent(), (Annotation[])anns);
            Assert.assertEquals((Object)"ok", (Object)observer.getResult());
        }
        catch (Exception e) {
            System.out.println(e.getMessage());
            exc = e;
        }
        Assert.assertNotNull((Object)exc);
    }
}

